/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.apexes.wsonrpc.core.WsonrpcCallback;

class WsonrpcCallbackCache {
    private final Map<String, CallbackWeakReference> map = new ConcurrentHashMap<String, CallbackWeakReference>();
    private final ReferenceQueue<WsonrpcCallback> queue = new ReferenceQueue();

    WsonrpcCallbackCache() {
    }

    void put(String requestId, WsonrpcCallback callback) {
        this.processQueue();
        this.map.put(requestId, new CallbackWeakReference(requestId, callback, this.queue));
    }

    WsonrpcCallback out(String requestId) {
        this.processQueue();
        CallbackWeakReference ref = this.map.remove(requestId);
        if (ref != null) {
            return (WsonrpcCallback)ref.get();
        }
        return null;
    }

    private void processQueue() {
        CallbackWeakReference ref;
        while ((ref = (CallbackWeakReference)this.queue.poll()) != null) {
            this.map.remove(ref.requestId);
        }
    }

    private static class CallbackWeakReference
    extends WeakReference<WsonrpcCallback> {
        private final String requestId;

        CallbackWeakReference(String requestId, WsonrpcCallback referent, ReferenceQueue<? super WsonrpcCallback> q) {
            super(referent, q);
            this.requestId = requestId;
        }
    }
}

