/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.json.support.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Type;
import net.apexes.wsonrpc.core.JsonException;
import net.apexes.wsonrpc.json.JsonRpcError;
import net.apexes.wsonrpc.json.JsonRpcErrorCause;
import net.apexes.wsonrpc.json.JsonRpcResponse;

class JacksonJsonRpcResponse
implements JsonRpcResponse {
    private final ObjectMapper objectMapper;
    private final ObjectNode objectNode;
    private final String id;
    private final JsonNode result;
    private final JsonRpcError error;

    JacksonJsonRpcResponse(ObjectMapper objectMapper, ObjectNode objectNode) {
        JsonNode node;
        this.objectMapper = objectMapper;
        this.objectNode = objectNode;
        this.id = objectNode.has("id") ? ((node = objectNode.get("id")).isNull() ? null : node.textValue()) : null;
        if (objectNode.has("result")) {
            this.result = objectNode.get("result");
            this.error = null;
        } else {
            JsonNode dataNode;
            JsonNode node2;
            JsonNode errorNode = objectNode.get("error");
            int code = errorNode.get("code").intValue();
            String message = null;
            JsonRpcErrorCause data = null;
            if (errorNode.has("message") && !(node2 = errorNode.get("message")).isNull()) {
                message = node2.textValue();
            }
            if (errorNode.has("data") && !(dataNode = errorNode.get("data")).isNull()) {
                data = (JsonRpcErrorCause)objectMapper.convertValue((Object)dataNode, JsonRpcErrorCause.class);
            }
            this.result = null;
            this.error = new JsonRpcError(code, message, data);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public Object getResultValue(Type type) {
        if (this.result == null) {
            return null;
        }
        return this.objectMapper.convertValue((Object)this.result, this.objectMapper.constructType(type));
    }

    @Override
    public String getResultAsJson() throws JsonException {
        try {
            return this.objectMapper.writeValueAsString((Object)this.result);
        }
        catch (JsonProcessingException e) {
            throw new JsonException(e);
        }
    }

    @Override
    public JsonRpcError getError() {
        return this.error;
    }

    @Override
    public String toJson() throws JsonException {
        try {
            return this.objectMapper.writeValueAsString((Object)this.objectNode);
        }
        catch (JsonProcessingException e) {
            throw new JsonException(e);
        }
    }

    @Override
    public boolean isRequest() {
        return false;
    }

    @Override
    public boolean isResponse() {
        return true;
    }
}

