/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.apexes.wsonrpc.core.BinaryWrapper;

public class GZIPBinaryWrapper
implements BinaryWrapper {
    @Override
    public byte[] read(byte[] bytes) throws IOException {
        int len;
        GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(bytes));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        return out.toByteArray();
    }

    @Override
    public byte[] write(byte[] bytes) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzipOut = new GZIPOutputStream(out);
        gzipOut.write(bytes);
        gzipOut.finish();
        gzipOut.flush();
        return out.toByteArray();
    }
}

