/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.apexes.wsonrpc.core.ReflectServiceHolder;
import net.apexes.wsonrpc.core.ReflectServiceMethodInvoker;

public class ServiceRegistry {
    private final ConcurrentMap<String, ReflectServiceHolder> holders = new ConcurrentHashMap<String, ReflectServiceHolder>();

    public <T> Binder<T> bind(Class<T> interfaceClass) {
        return new Binder<T>(interfaceClass);
    }

    public <T> Binder<T> simpleNameIfNull(Class<T> interfaceClass) {
        return new Binder<T>(interfaceClass).simpleNameIfNull();
    }

    public <T> ServiceRegistry register(String name, Class<T> interfaceClass, T instance) {
        if (this.holders.containsKey(name)) {
            throw new IllegalArgumentException("service already exists");
        }
        this.holders.put(name, new ReflectServiceHolder<T>(interfaceClass, instance));
        return this;
    }

    public ServiceRegistry unregister(String name) {
        this.holders.remove(name);
        return this;
    }

    ReflectServiceMethodInvoker getInvoker(String serviceMethod) {
        ReflectServiceHolder holder;
        String serviceName = null;
        String methodName = serviceMethod;
        int lastIndex = serviceMethod.lastIndexOf(46);
        if (lastIndex >= 0) {
            serviceName = serviceMethod.substring(0, lastIndex);
            methodName = serviceMethod.substring(lastIndex + 1);
        }
        if ((holder = (ReflectServiceHolder)this.holders.get(serviceName)) != null) {
            return holder.findInvoker(methodName);
        }
        return null;
    }

    public class Binder<T> {
        private final Class<T> interfaceClass;
        private String customServiceName;
        private boolean simpleNameIfNull = false;

        Binder(Class<T> interfaceClass) {
            this.interfaceClass = interfaceClass;
        }

        public Binder<T> serviceName(String serviceName) {
            this.customServiceName = serviceName;
            this.simpleNameIfNull = false;
            return this;
        }

        public Binder<T> simpleNameIfNull() {
            this.customServiceName = null;
            this.simpleNameIfNull = true;
            return this;
        }

        public ServiceRegistry toInstance(T instance) {
            String serviceName = this.customServiceName != null ? this.customServiceName : (this.simpleNameIfNull ? this.interfaceClass.getSimpleName() : this.interfaceClass.getName());
            return ServiceRegistry.this.register(serviceName, this.interfaceClass, instance);
        }
    }
}

