/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.json.support.gson;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import net.apexes.wsonrpc.json.JsonRpcRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GsonJsonRpcRequest
implements JsonRpcRequest {
    private static final Logger LOG = LoggerFactory.getLogger(GsonJsonRpcRequest.class);
    private final Gson gson;
    private final JsonObject jsonObject;
    private final String id;
    private final String method;
    private final JsonArray params;

    GsonJsonRpcRequest(Gson gson, JsonObject jsonObject) {
        JsonElement element;
        this.gson = gson;
        this.jsonObject = jsonObject;
        this.id = jsonObject.has("id") ? ((element = jsonObject.get("id")).isJsonNull() ? null : element.getAsString()) : null;
        this.method = jsonObject.get("method").getAsString();
        this.params = jsonObject.getAsJsonArray("params");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public int getParamCount() {
        if (this.params == null) {
            return 0;
        }
        return this.params.size();
    }

    @Override
    public Object getParams() {
        return this.params;
    }

    @Override
    public Object[] getParams(Type[] types) {
        if (this.params == null) {
            return new Object[0];
        }
        try {
            Object[] args = new Object[types.length];
            for (int i = 0; i < args.length; ++i) {
                JsonElement param = this.params.get(i);
                args[i] = param.isJsonNull() ? null : this.gson.fromJson(param, types[i]);
            }
            return args;
        }
        catch (Exception e) {
            LOG.debug("params error!", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getParamsAsJson() {
        return this.gson.toJson((JsonElement)this.params);
    }

    @Override
    public String toJson() {
        return this.gson.toJson((JsonElement)this.jsonObject);
    }

    @Override
    public boolean isRequest() {
        return true;
    }

    @Override
    public boolean isResponse() {
        return false;
    }
}

