/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.json.support.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import net.apexes.wsonrpc.json.JsonRpcError;
import net.apexes.wsonrpc.json.JsonRpcErrorCause;
import net.apexes.wsonrpc.json.JsonRpcResponse;

class GsonJsonRpcResponse
implements JsonRpcResponse {
    private final Gson gson;
    private final JsonObject jsonObject;
    private final String id;
    private final JsonElement result;
    private final JsonRpcError error;

    GsonJsonRpcResponse(Gson gson, JsonObject jsonObject) {
        JsonElement element;
        this.gson = gson;
        this.jsonObject = jsonObject;
        this.id = jsonObject.has("id") ? ((element = jsonObject.get("id")).isJsonNull() ? null : element.getAsString()) : null;
        if (jsonObject.has("result")) {
            this.result = jsonObject.get("result");
            this.error = null;
        } else {
            JsonObject dataJsonObject;
            JsonElement element2;
            JsonObject errorObject = jsonObject.getAsJsonObject("error");
            int code = errorObject.get("code").getAsInt();
            String message = null;
            JsonRpcErrorCause data = null;
            if (errorObject.has("message") && !(element2 = errorObject.get("message")).isJsonNull()) {
                message = element2.getAsString();
            }
            if (errorObject.has("data") && !(dataJsonObject = errorObject.getAsJsonObject("data")).isJsonNull()) {
                data = (JsonRpcErrorCause)gson.fromJson((JsonElement)dataJsonObject, JsonRpcErrorCause.class);
            }
            this.result = null;
            this.error = new JsonRpcError(code, message, data);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public Object getResultValue(Type type) {
        if (this.result == null) {
            return null;
        }
        return this.gson.fromJson(this.result, type);
    }

    @Override
    public String getResultAsJson() {
        return this.gson.toJson(this.result);
    }

    @Override
    public JsonRpcError getError() {
        return this.error;
    }

    @Override
    public String toJson() {
        return this.gson.toJson((JsonElement)this.jsonObject);
    }

    @Override
    public boolean isRequest() {
        return false;
    }

    @Override
    public boolean isResponse() {
        return true;
    }
}

