/*
 * Copyright (C) 2016, apexes.net. All rights reserved.
 * 
 *        http://www.apexes.net
 * 
 */
package net.apexes.wsonrpc.core;

import net.apexes.wsonrpc.json.JsonRpcError;
import net.apexes.wsonrpc.util.JsonRpcErrors;

/**
 * 
 * @author <a href="mailto:hedyn@foxmail.com">HeDYn</a>
 *
 */
public class RemoteException extends Exception {
    private static final long serialVersionUID = 1L;

    private final JsonRpcError error;

    private RemoteException(String message, Throwable cause, JsonRpcError error) {
        super(message, cause);
        this.error = error;
    }

    public JsonRpcError getJsonRpcError() {
        return error;
    }

    static RemoteException of(JsonRpcError error) {
        String message = formatMessage(error);
        Throwable cause = JsonRpcErrors.fromCause(error.getData());
        return new RemoteException(message, cause, error);
    }

    private static String formatMessage(JsonRpcError error) {
        StringBuilder str = new StringBuilder();
        if (error.getCode() != null) {
            str.append(error.getCode());
        }
        if (error.getMessage() != null) {
            str.append(" ");
            str.append(error.getMessage());
        }
        return str.toString();
    }
}
