/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.apexes.wsonrpc.core.ServiceMethodInvoker;

class ServiceReflectHolder<T> {
    private final T instance;
    private final Map<String, Set<Method>> methodFinder;

    ServiceReflectHolder(Class<T> interfaceClass, T instance) {
        if (interfaceClass == null) {
            throw new NullPointerException("interfaceClass");
        }
        if (instance == null) {
            throw new NullPointerException("instance");
        }
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("class should be an interface : " + interfaceClass);
        }
        if (!interfaceClass.isInstance(instance)) {
            throw new IllegalArgumentException("instance should be implements " + interfaceClass);
        }
        this.instance = instance;
        HashMap<String, HashSet<Method>> map = new HashMap<String, HashSet<Method>>();
        for (Method method : interfaceClass.getMethods()) {
            String methodName = method.getName();
            HashSet<Method> set = (HashSet<Method>)map.get(methodName);
            if (set == null) {
                set = new HashSet<Method>();
                map.put(methodName, set);
            }
            set.add(method);
        }
        this.methodFinder = Collections.unmodifiableMap(map);
    }

    ServiceMethodInvoker findInvoker(String methodName) {
        Set<Method> methods = this.methodFinder.get(methodName);
        if (methods == null) {
            return null;
        }
        return new ServiceMethodInvoker(this.instance, methods);
    }
}

