/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.io.EOFException;
import java.io.IOException;
import java.util.concurrent.Future;
import net.apexes.wsonrpc.core.JsonException;
import net.apexes.wsonrpc.core.JsonRpcEngine;
import net.apexes.wsonrpc.core.JsonRpcLogger;
import net.apexes.wsonrpc.core.RemoteException;
import net.apexes.wsonrpc.core.ServiceRegistry;
import net.apexes.wsonrpc.core.WebSocketSession;
import net.apexes.wsonrpc.core.WsonrpcCallback;
import net.apexes.wsonrpc.core.WsonrpcCallbackCache;
import net.apexes.wsonrpc.core.WsonrpcConfig;
import net.apexes.wsonrpc.core.WsonrpcException;
import net.apexes.wsonrpc.core.WsonrpcFuture;
import net.apexes.wsonrpc.core.WsonrpcLogger;
import net.apexes.wsonrpc.json.JsonImplementor;
import net.apexes.wsonrpc.json.JsonRpcMessage;
import net.apexes.wsonrpc.json.JsonRpcRequest;
import net.apexes.wsonrpc.json.JsonRpcResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsonrpcEngine {
    private static final Logger LOG = LoggerFactory.getLogger(WsonrpcEngine.class);
    protected final WsonrpcConfig config;
    protected final JsonRpcEngine jsonRpcEngine;
    protected final WsonrpcLogger wsonrpcLogger;
    private final WsonrpcCallbackCache callbackCache;

    public WsonrpcEngine(WsonrpcConfig config) {
        this.config = config;
        this.jsonRpcEngine = new JsonRpcEngine(config.getJsonImplementor(), config.getBinaryWrapper());
        this.wsonrpcLogger = config.getWsonrpcLogger();
        this.callbackCache = new WsonrpcCallbackCache();
    }

    public final WsonrpcConfig getConfig() {
        return this.config;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.jsonRpcEngine.getServiceRegistry();
    }

    public void notify(WebSocketSession session, String serviceName, String methodName, Object[] args) throws IOException, WsonrpcException {
        if (session == null) {
            throw new NullPointerException("session");
        }
        JsonRpcRequest request = this.jsonRpcEngine.createRequest(serviceName, methodName, args, null);
        if (this.wsonrpcLogger != null) {
            this.jsonRpcEngine.transmit(session, request, new JsonRpcLoggerAdapter(session, this.wsonrpcLogger));
        } else {
            this.jsonRpcEngine.transmit(session, request);
        }
    }

    public <T> Future<T> request(WebSocketSession session, String serviceName, String methodName, Object[] args, Class<T> returnType) throws IOException, WsonrpcException {
        String id = this.config.getIdGenerater().next();
        WsonrpcFuture<T> future = new WsonrpcFuture<T>(this, returnType);
        this.request(session, id, serviceName, methodName, args, future);
        return future;
    }

    public void request(WebSocketSession session, String serviceName, String methodName, Object[] args, WsonrpcCallback callback) throws IOException, WsonrpcException {
        String id = this.config.getIdGenerater().next();
        this.request(session, id, serviceName, methodName, args, callback);
    }

    private void request(WebSocketSession session, String id, String serviceName, String methodName, Object[] args, WsonrpcCallback callback) throws IOException, WsonrpcException {
        if (session == null) {
            throw new NullPointerException("session is null");
        }
        this.callbackCache.put(id, callback);
        try {
            JsonRpcRequest request = this.jsonRpcEngine.createRequest(serviceName, methodName, args, id);
            if (this.wsonrpcLogger != null) {
                this.jsonRpcEngine.transmit(session, request, new JsonRpcLoggerAdapter(session, this.wsonrpcLogger));
            } else {
                this.jsonRpcEngine.transmit(session, request);
            }
        }
        catch (Throwable t) {
            this.callbackCache.out(id);
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof WsonrpcException) {
                throw (WsonrpcException)t;
            }
            throw new WsonrpcException(t);
        }
    }

    public void handle(WebSocketSession session, byte[] bytes) throws IOException {
        block6: {
            if (session == null) {
                throw new EOFException("session is null");
            }
            try {
                JsonRpcMessage msg = this.wsonrpcLogger != null ? this.jsonRpcEngine.parseOnReceive(bytes, new JsonRpcLoggerAdapter(session, this.wsonrpcLogger)) : this.jsonRpcEngine.parseOnReceive(bytes);
                if (msg.isRequest()) {
                    this.handleRequest(session, (JsonRpcRequest)msg);
                } else if (msg instanceof JsonRpcResponse) {
                    this.handleResponse((JsonRpcResponse)msg);
                }
            }
            catch (Exception e) {
                if (this.wsonrpcLogger == null) break block6;
                this.wsonrpcLogger.onError(session.getId(), e);
            }
        }
    }

    protected void handleRequest(WebSocketSession session, JsonRpcRequest request) {
        this.transmit(session, this.execute(session, request));
    }

    protected void handleResponse(JsonRpcResponse response) {
        String id = response.getId();
        if (id == null) {
            return;
        }
        WsonrpcCallback callback = this.callbackCache.out(id);
        if (callback == null) {
            LOG.warn("callback is null. id={}", (Object)id);
        } else {
            try {
                callback.setValue(response);
            }
            catch (Throwable t) {
                callback.setError(t);
            }
        }
    }

    protected JsonRpcResponse execute(WebSocketSession session, JsonRpcRequest request) {
        return this.jsonRpcEngine.execute(request);
    }

    protected void transmit(WebSocketSession session, JsonRpcResponse resp) {
        block5: {
            if (resp != null) {
                try {
                    if (this.wsonrpcLogger != null) {
                        this.jsonRpcEngine.transmit(session, resp, new JsonRpcLoggerAdapter(session, this.wsonrpcLogger));
                    } else {
                        this.jsonRpcEngine.transmit(session, resp);
                    }
                }
                catch (Exception e) {
                    if (this.wsonrpcLogger == null) break block5;
                    this.wsonrpcLogger.onError(session.getId(), e);
                }
            }
        }
    }

    protected JsonImplementor getJsonImplementor() {
        return this.jsonRpcEngine.getJsonImplementor();
    }

    protected JsonRpcResponse toResponse(String id, Object result) {
        return this.getJsonImplementor().createResponse(id, result);
    }

    protected <T> T fromResponse(JsonRpcResponse resp, Class<T> returnType) throws JsonException, RemoteException {
        return this.jsonRpcEngine.fromResponse(resp, returnType);
    }

    private static class JsonRpcLoggerAdapter
    implements JsonRpcLogger {
        private final WebSocketSession session;
        private final WsonrpcLogger logger;

        private JsonRpcLoggerAdapter(WebSocketSession session, WsonrpcLogger logger) {
            this.session = session;
            this.logger = logger;
        }

        @Override
        public void onReceive(String json) {
            this.logger.onReceive(this.session.getId(), json);
        }

        @Override
        public void onTransmit(String json) {
            this.logger.onTransmit(this.session.getId(), json);
        }
    }
}

