/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import net.apexes.wsonrpc.core.BinaryWrapper;
import net.apexes.wsonrpc.core.JsonRpcLogger;
import net.apexes.wsonrpc.core.ServiceMethodInvoker;
import net.apexes.wsonrpc.core.ServiceRegistry;
import net.apexes.wsonrpc.core.Transport;
import net.apexes.wsonrpc.core.exception.JsonException;
import net.apexes.wsonrpc.core.exception.RemoteException;
import net.apexes.wsonrpc.json.JsonImplementor;
import net.apexes.wsonrpc.json.JsonRpcMessage;
import net.apexes.wsonrpc.json.JsonRpcRequest;
import net.apexes.wsonrpc.json.JsonRpcResponse;
import net.apexes.wsonrpc.util.JsonRpcErrors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcEngine {
    private static final Logger LOG = LoggerFactory.getLogger(JsonRpcEngine.class);
    private final JsonImplementor jsonImpl;
    private final BinaryWrapper binaryWrapper;
    private final ServiceRegistry serviceRegistry;
    private JsonRpcLogger jsonRpcLogger;

    public JsonRpcEngine(JsonImplementor jsonImpl) {
        this(jsonImpl, null);
    }

    public JsonRpcEngine(JsonImplementor jsonImpl, BinaryWrapper binaryWrapper) {
        if (jsonImpl == null) {
            throw new NullPointerException("jsonImpl");
        }
        this.jsonImpl = jsonImpl;
        this.binaryWrapper = binaryWrapper;
        this.serviceRegistry = new ServiceRegistry();
    }

    protected JsonImplementor getJsonImplementor() {
        return this.jsonImpl;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public JsonRpcLogger getJsonRpcLogger() {
        return this.jsonRpcLogger;
    }

    public void setJsonRpcLogger(JsonRpcLogger jsonRpcLogger) {
        this.jsonRpcLogger = jsonRpcLogger;
    }

    public void invoke(String serviceName, String methodName, Object[] args, String id, Transport transport) throws IOException, JsonException {
        this.transmit(transport, this.createRequest(serviceName, methodName, args, id));
    }

    protected JsonRpcRequest createRequest(String serviceName, String methodName, Object[] args, String id) {
        if (methodName == null) {
            throw new NullPointerException("methodName");
        }
        String method = serviceName == null || serviceName.isEmpty() ? methodName : serviceName + "." + methodName;
        return this.jsonImpl.createRequest(id, method, args);
    }

    public void receiveRequest(byte[] bytes, Transport transport) throws IOException, JsonException {
        JsonRpcResponse resp;
        try {
            JsonRpcMessage msg = this.parseOnReceive(bytes);
            resp = msg.isRequest() ? this.execute((JsonRpcRequest)msg) : this.jsonImpl.createResponse(JsonRpcErrors.invalidRequestError());
        }
        catch (JsonException e) {
            resp = this.jsonImpl.createResponse(JsonRpcErrors.parseError(e));
        }
        catch (IOException e) {
            resp = this.jsonImpl.createResponse(JsonRpcErrors.internalError(e));
        }
        this.transmit(transport, resp);
    }

    public <T> T receiveResponse(byte[] bytes, Type returnType) throws IOException, JsonException, RemoteException {
        JsonRpcMessage msg;
        try {
            msg = this.parseOnReceive(bytes);
        }
        catch (JsonException e) {
            throw new JsonException("parse response error", e);
        }
        if (msg instanceof JsonRpcResponse) {
            return this.fromResponse((JsonRpcResponse)msg, returnType);
        }
        throw new JsonException("invalid response");
    }

    protected JsonRpcResponse execute(JsonRpcRequest request) {
        if (request == null) {
            return this.jsonImpl.createResponse(JsonRpcErrors.parseError());
        }
        String id = request.getId();
        String serviceMethod = request.getMethod();
        ServiceMethodInvoker invoker = this.serviceRegistry.getInvoker(serviceMethod);
        if (invoker == null) {
            return this.jsonImpl.createResponse(id, JsonRpcErrors.methodNotFoundError(serviceMethod));
        }
        if (invoker.validateParameters(request)) {
            try {
                Object invokeValue = invoker.invoke();
                if (id == null) {
                    return null;
                }
                return this.jsonImpl.createResponse(id, invokeValue);
            }
            catch (Throwable t) {
                Throwable throwable = t;
                if (throwable instanceof InvocationTargetException) {
                    throwable = ((InvocationTargetException)throwable).getTargetException();
                }
                LOG.debug("executing error. " + serviceMethod, throwable);
                return this.jsonImpl.createResponse(id, JsonRpcErrors.serverError(2, serviceMethod, throwable));
            }
        }
        return this.jsonImpl.createResponse(id, JsonRpcErrors.invalidParamsError(serviceMethod));
    }

    protected <T> T fromResponse(JsonRpcResponse resp, Type returnType) throws JsonException {
        if (resp.getError() != null) {
            throw RemoteException.create(resp.getError());
        }
        Object resultValue = resp.getResultValue(returnType);
        if (resultValue == null) {
            return null;
        }
        try {
            return (T)resultValue;
        }
        catch (Throwable t) {
            throw new JsonException(t.getMessage(), t);
        }
    }

    protected JsonRpcMessage parseOnReceive(byte[] bytes) throws IOException, JsonException {
        JsonRpcLogger logger = this.jsonRpcLogger;
        return this.parseOnReceive(bytes, logger);
    }

    protected JsonRpcMessage parseOnReceive(byte[] bytes, JsonRpcLogger logger) throws IOException, JsonException {
        if (this.binaryWrapper != null) {
            LOG.debug(" - {}", (Object)bytes.length);
            bytes = this.binaryWrapper.read(bytes);
            LOG.debug(" = {}", (Object)bytes.length);
        }
        String json = new String(bytes, StandardCharsets.UTF_8);
        if (logger != null) {
            logger.onReceive(json);
        } else {
            LOG.debug(" <<  {}", (Object)json);
        }
        return this.jsonImpl.fromJson(json);
    }

    protected void transmit(Transport transport, JsonRpcMessage message) throws IOException, JsonException {
        JsonRpcLogger logger = this.jsonRpcLogger;
        this.transmit(transport, message, logger);
    }

    protected void transmit(Transport transport, JsonRpcMessage message, JsonRpcLogger logger) throws IOException, JsonException {
        String json = message.toJson();
        if (logger != null) {
            logger.onTransmit(json);
        } else {
            LOG.debug(" >>  {}", (Object)json);
        }
        byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
        if (this.binaryWrapper != null) {
            LOG.debug(" = {}", (Object)bytes.length);
            bytes = this.binaryWrapper.write(bytes);
            LOG.debug(" - {}", (Object)bytes.length);
        }
        transport.sendBinary(bytes);
    }
}

