/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.apexes.wsonrpc.core.Remote;
import net.apexes.wsonrpc.core.exception.WsonrpcRuntimeException;

public final class RemoteInvoker {
    private final Remote remote;
    private String serviceName;
    private boolean simpleName = false;
    private ClassLoader classLoader;
    private int timeout;

    public static RemoteInvoker create(Remote remote) {
        return new RemoteInvoker(remote);
    }

    private RemoteInvoker(Remote remote) {
        this.remote = remote;
    }

    public RemoteInvoker serviceName(String serviceName) {
        this.serviceName = serviceName;
        this.simpleName = false;
        return this;
    }

    public RemoteInvoker simpleName() {
        this.serviceName = null;
        this.simpleName = true;
        return this;
    }

    @Deprecated
    public RemoteInvoker simpleNameIfNull() {
        return this.simpleName();
    }

    public RemoteInvoker classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public RemoteInvoker timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public <T> T get(Class<T> serviceClass) {
        if (this.classLoader == null) {
            this.classLoader = serviceClass.getClassLoader();
        }
        InvocationHandlerImpl handler = new InvocationHandlerImpl(this.remote, this.serviceName(serviceClass), this.timeout);
        return (T)Proxy.newProxyInstance(this.classLoader, new Class[]{serviceClass}, (InvocationHandler)handler);
    }

    private String serviceName(Class<?> serviceClass) {
        if (this.serviceName != null) {
            return this.serviceName;
        }
        if (this.simpleName) {
            return serviceClass.getSimpleName();
        }
        return serviceClass.getName();
    }

    private static Object proxyObjectMethods(Method method, Object proxyObject, Object[] args) {
        String name = method.getName();
        if ("toString".equals(name)) {
            return proxyObject.getClass().getName() + "@" + System.identityHashCode(proxyObject);
        }
        if ("hashCode".equals(name)) {
            return System.identityHashCode(proxyObject);
        }
        if ("equals".equals(name)) {
            return proxyObject == args[0];
        }
        throw new RuntimeException(method.getName() + " is not a member of java.lang.Object");
    }

    private static class InvocationHandlerImpl
    implements InvocationHandler {
        private final Remote remote;
        private final String serviceName;
        private final int timeout;

        InvocationHandlerImpl(Remote remote, String serviceName, int timeout) {
            this.remote = remote;
            this.serviceName = serviceName;
            this.timeout = timeout;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return RemoteInvoker.proxyObjectMethods(method, proxy, args);
            }
            try {
                Class<?> returnType = method.getReturnType();
                if (returnType == Void.TYPE) {
                    this.remote.notify(this.serviceName, method.getName(), args);
                    return null;
                }
                return this.remote.request(this.serviceName, method.getName(), args, returnType, this.timeout);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WsonrpcRuntimeException(e.getMessage(), e);
            }
        }
    }
}

