/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.apexes.wsonrpc.core.ServiceMethodInvoker;
import net.apexes.wsonrpc.core.ServiceReflectHolder;

public class ServiceRegistry {
    private final ConcurrentMap<String, ServiceReflectHolder<?>> holders = new ConcurrentHashMap();
    private boolean allSimpleName = false;

    ServiceRegistry() {
    }

    public ServiceRegistry allSimpleName() {
        this.allSimpleName = true;
        return this;
    }

    public <T> Binder<T> bind(Class<T> interfaceClass) {
        return new Binder<T>(interfaceClass);
    }

    @Deprecated
    public <T> Binder<T> simpleNameIfNull(Class<T> interfaceClass) {
        return this.simpleName(interfaceClass);
    }

    public <T> Binder<T> simpleName(Class<T> interfaceClass) {
        return new Binder<T>(interfaceClass).simpleName();
    }

    public <T> ServiceRegistry register(String name, Class<T> interfaceClass, T instance) {
        if (this.holders.containsKey(name)) {
            throw new IllegalArgumentException("service already exists");
        }
        this.holders.put(name, new ServiceReflectHolder<T>(interfaceClass, instance));
        return this;
    }

    public ServiceRegistry unregister(String name) {
        this.holders.remove(name);
        return this;
    }

    ServiceMethodInvoker getInvoker(String serviceMethod) {
        int lastIndex = serviceMethod.lastIndexOf(46);
        if (lastIndex < 0) {
            return null;
        }
        String serviceName = serviceMethod.substring(0, lastIndex);
        String methodName = serviceMethod.substring(lastIndex + 1);
        ServiceReflectHolder holder = (ServiceReflectHolder)this.holders.get(serviceName);
        if (holder != null) {
            return holder.findInvoker(methodName);
        }
        return null;
    }

    public class Binder<T> {
        private final Class<T> interfaceClass;
        private String serviceName;
        private boolean simpleName = false;

        Binder(Class<T> interfaceClass) {
            this.interfaceClass = interfaceClass;
        }

        public Binder<T> serviceName(String serviceName) {
            this.serviceName = serviceName;
            this.simpleName = false;
            return this;
        }

        @Deprecated
        public Binder<T> simpleNameIfNull() {
            return this.simpleName();
        }

        public Binder<T> simpleName() {
            this.serviceName = null;
            this.simpleName = true;
            return this;
        }

        public ServiceRegistry toInstance(T instance) {
            return ServiceRegistry.this.register(this.serviceName(this.interfaceClass), this.interfaceClass, instance);
        }

        private String serviceName(Class<T> serviceClass) {
            if (this.serviceName != null) {
                return this.serviceName;
            }
            if (this.simpleName || ServiceRegistry.this.allSimpleName) {
                return serviceClass.getSimpleName();
            }
            return serviceClass.getName();
        }
    }
}

