/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core.exception;

import net.apexes.wsonrpc.core.exception.RemoteInternalException;
import net.apexes.wsonrpc.core.exception.RemoteInvalidParamsException;
import net.apexes.wsonrpc.core.exception.RemoteInvalidRequestException;
import net.apexes.wsonrpc.core.exception.RemoteMethodNotFoundException;
import net.apexes.wsonrpc.core.exception.RemoteParseException;
import net.apexes.wsonrpc.core.exception.RemoteServerException;
import net.apexes.wsonrpc.core.exception.WsonrpcRuntimeException;
import net.apexes.wsonrpc.json.JsonRpcError;
import net.apexes.wsonrpc.util.JsonRpcErrors;

public class RemoteException
extends WsonrpcRuntimeException {
    private static final long serialVersionUID = 1L;
    private final JsonRpcError error;

    protected RemoteException(String message, Throwable cause, JsonRpcError error) {
        super(message, cause);
        this.error = error;
    }

    public JsonRpcError getJsonRpcError() {
        return this.error;
    }

    public static RemoteException create(JsonRpcError error) {
        String message = RemoteException.formatMessage(error);
        Throwable cause = JsonRpcErrors.fromCause(error.getData());
        if (error.getCode() != null) {
            switch (error.getCode()) {
                case -32700: {
                    return new RemoteParseException(message, cause, error);
                }
                case -32600: {
                    return new RemoteInvalidRequestException(message, cause, error);
                }
                case -32601: {
                    return new RemoteMethodNotFoundException(message, cause, error);
                }
                case -32602: {
                    return new RemoteInvalidParamsException(message, cause, error);
                }
                case -32603: {
                    return new RemoteInternalException(message, cause, error);
                }
            }
            return new RemoteServerException(message, cause, error);
        }
        return new RemoteServerException(message, cause, error);
    }

    private static String formatMessage(JsonRpcError error) {
        StringBuilder str = new StringBuilder();
        if (error.getCode() != null) {
            str.append(error.getCode());
        }
        if (error.getMessage() != null) {
            if (str.length() > 0) {
                str.append(", ");
            }
            str.append(error.getMessage());
        }
        return str.toString();
    }
}

