/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.json.support.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Reader;
import java.io.StringReader;
import net.apexes.wsonrpc.core.exception.JsonException;
import net.apexes.wsonrpc.json.JsonImplementor;
import net.apexes.wsonrpc.json.JsonRpcError;
import net.apexes.wsonrpc.json.JsonRpcMessage;
import net.apexes.wsonrpc.json.JsonRpcRequest;
import net.apexes.wsonrpc.json.JsonRpcResponse;
import net.apexes.wsonrpc.json.support.gson.GsonJsonRpcRequest;
import net.apexes.wsonrpc.json.support.gson.GsonJsonRpcResponse;

public class GsonImplementor
implements JsonImplementor {
    private final Gson gson;

    public GsonImplementor() {
        this(new Gson());
    }

    public GsonImplementor(Gson gson) {
        this.gson = gson;
    }

    @Override
    public JsonRpcMessage fromJson(String json) throws JsonException {
        try {
            JsonParser parser = new JsonParser();
            JsonObject jsonObject = (JsonObject)parser.parse((Reader)new StringReader(json));
            if (jsonObject.has("method")) {
                return new GsonJsonRpcRequest(this.gson, jsonObject);
            }
            return new GsonJsonRpcResponse(this.gson, jsonObject);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    @Override
    public JsonRpcRequest createRequest(String id, String method, Object[] params) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("jsonrpc", "2.0");
        if (id != null) {
            jsonObject.addProperty("id", id);
        }
        jsonObject.addProperty("method", method);
        if (params != null) {
            jsonObject.add("params", this.element(params));
        }
        return new GsonJsonRpcRequest(this.gson, jsonObject);
    }

    @Override
    public JsonRpcResponse createResponse(String id, Object result) {
        return this.createResponse(id, "result", result);
    }

    @Override
    public JsonRpcResponse createResponse(JsonRpcError error) {
        return this.createResponse(null, error);
    }

    @Override
    public JsonRpcResponse createResponse(String id, JsonRpcError error) {
        return this.createResponse(id, "error", error);
    }

    private JsonRpcResponse createResponse(String id, String propertyName, Object object) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("jsonrpc", "2.0");
        if (id != null) {
            jsonObject.addProperty("id", id);
        }
        jsonObject.add(propertyName, this.element(object));
        return new GsonJsonRpcResponse(this.gson, jsonObject);
    }

    private JsonElement element(Object object) {
        String paramsJson = this.gson.toJson(object);
        JsonParser parser = new JsonParser();
        return parser.parse((Reader)new StringReader(paramsJson));
    }
}

