/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.apexes.wsonrpc.core.ServiceRegistry;
import net.apexes.wsonrpc.core.WebSocketSession;
import net.apexes.wsonrpc.core.WsonrpcCallback;
import net.apexes.wsonrpc.core.WsonrpcEngine;
import net.apexes.wsonrpc.core.WsonrpcRemote;
import net.apexes.wsonrpc.core.exception.RemoteException;
import net.apexes.wsonrpc.core.exception.WsonrpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsonrpcEndpoint
implements WsonrpcRemote {
    private static final Logger LOG = LoggerFactory.getLogger(WsonrpcEndpoint.class);
    private final WsonrpcEngine wsonrpcEngine;
    private WebSocketSession session;
    private String closedSessonId;

    protected WsonrpcEndpoint(WsonrpcEngine wsonrpcEngine) {
        this.wsonrpcEngine = wsonrpcEngine;
    }

    protected WsonrpcEngine getWsonrpcEngine() {
        return this.wsonrpcEngine;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.wsonrpcEngine.getServiceRegistry();
    }

    protected final void openSession(WebSocketSession session) {
        this.session = session;
    }

    protected void closeSession() throws Exception {
        if (this.session != null) {
            this.session.close();
            this.closedSessonId = this.session.getId();
            this.session = null;
        }
    }

    protected WebSocketSession getSession() {
        return this.session;
    }

    protected String getClosedSessonId() {
        return this.closedSessonId;
    }

    protected void verifyOnline() throws WsonrpcException {
        if (!this.isConnected()) {
            throw new WsonrpcException("Connection is closed.");
        }
    }

    @Override
    public boolean isConnected() {
        return this.session != null && this.session.isOpen();
    }

    @Override
    public String getSessionId() {
        if (this.session != null) {
            return this.session.getId();
        }
        return null;
    }

    @Override
    public void disconnect() {
        try {
            this.closeSession();
        }
        catch (Exception e) {
            LOG.warn("disconnect error!");
        }
    }

    @Override
    public void ping(byte[] payload) throws Exception {
        this.verifyOnline();
        this.session.ping(payload);
    }

    @Override
    public void notify(String serviceName, String methodName, Object[] args) throws IOException, WsonrpcException {
        this.verifyOnline();
        this.wsonrpcEngine.notify(this.getSession(), serviceName, methodName, args);
    }

    @Override
    public <T> T request(String serviceName, String methodName, Object[] args, Class<T> returnType, int timeout) throws IOException, WsonrpcException, RemoteException {
        Future<T> future = this.request(serviceName, methodName, args, returnType);
        try {
            if (timeout <= 0) {
                return future.get();
            }
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            Throwable throwable = e;
            if (throwable instanceof ExecutionException) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof RemoteException) {
                throw (RemoteException)throwable;
            }
            if (throwable instanceof WsonrpcException) {
                throw (WsonrpcException)throwable;
            }
            throw new WsonrpcException("Invoke " + serviceName + "." + methodName + " failed.", throwable);
        }
    }

    @Override
    public <T> Future<T> request(String serviceName, String methodName, Object[] args, Class<T> returnType) throws IOException, WsonrpcException {
        this.verifyOnline();
        return this.wsonrpcEngine.request(this.session, serviceName, methodName, args, returnType);
    }

    @Override
    public void request(String serviceName, String methodName, Object[] args, WsonrpcCallback callback) throws IOException, WsonrpcException {
        this.wsonrpcEngine.request(this.session, serviceName, methodName, args, callback);
    }
}

