/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.json.support.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.IOException;
import net.apexes.wsonrpc.core.exception.JsonException;
import net.apexes.wsonrpc.json.JsonImplementor;
import net.apexes.wsonrpc.json.JsonRpcError;
import net.apexes.wsonrpc.json.JsonRpcMessage;
import net.apexes.wsonrpc.json.JsonRpcRequest;
import net.apexes.wsonrpc.json.JsonRpcResponse;
import net.apexes.wsonrpc.json.support.jackson.JacksonJsonRpcRequest;
import net.apexes.wsonrpc.json.support.jackson.JacksonJsonRpcResponse;

public class JacksonImplementor
implements JsonImplementor {
    private final ObjectMapper objectMapper;

    public JacksonImplementor() {
        this(new ObjectMapper());
    }

    public JacksonImplementor(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public JsonRpcMessage fromJson(String json) throws JsonException {
        try {
            ObjectNode objectNode = (ObjectNode)this.objectMapper.readTree(json);
            if (objectNode.has("method")) {
                return new JacksonJsonRpcRequest(this.objectMapper, objectNode);
            }
            return new JacksonJsonRpcResponse(this.objectMapper, objectNode);
        }
        catch (IOException e) {
            throw new JsonException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public JsonRpcRequest createRequest(String id, String method, Object[] params) {
        ObjectNode objectNode = this.objectMapper.getNodeFactory().objectNode();
        objectNode.put("jsonrpc", "2.0");
        if (id != null) {
            objectNode.put("id", id);
        }
        objectNode.put("method", method);
        if (params != null) {
            ArrayNode arrayNode = objectNode.putArray("params");
            for (Object param : params) {
                arrayNode.add((JsonNode)this.objectMapper.getNodeFactory().pojoNode(param));
            }
        }
        return new JacksonJsonRpcRequest(this.objectMapper, objectNode);
    }

    @Override
    public JsonRpcResponse createResponse(String id, Object result) {
        ValueNode resultNode = this.objectMapper.getNodeFactory().pojoNode(result);
        return this.createResponse(id, "result", (JsonNode)resultNode);
    }

    @Override
    public JsonRpcResponse createResponse(JsonRpcError error) {
        return this.createResponse(null, error);
    }

    @Override
    public JsonRpcResponse createResponse(String id, JsonRpcError error) {
        ObjectNode errorNode = this.objectMapper.getNodeFactory().objectNode();
        errorNode.put("code", error.getCode());
        if (error.getMessage() != null) {
            errorNode.put("message", error.getMessage());
        }
        if (error.getData() != null) {
            errorNode.set("data", (JsonNode)this.objectMapper.getNodeFactory().pojoNode((Object)error.getData()));
        }
        return this.createResponse(id, "error", (JsonNode)errorNode);
    }

    private JsonRpcResponse createResponse(String id, String fieldName, JsonNode jsonNode) {
        ObjectNode objectNode = this.objectMapper.getNodeFactory().objectNode();
        objectNode.put("jsonrpc", "2.0");
        if (id != null) {
            objectNode.put("id", id);
        }
        objectNode.set(fieldName, jsonNode);
        return new JacksonJsonRpcResponse(this.objectMapper, objectNode);
    }
}

