/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.json.support.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Type;
import net.apexes.wsonrpc.core.exception.JsonException;
import net.apexes.wsonrpc.json.JsonRpcRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JacksonJsonRpcRequest
implements JsonRpcRequest {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonJsonRpcRequest.class);
    private final ObjectMapper objectMapper;
    private final ObjectNode objectNode;
    private final String id;
    private final String method;
    private final ContainerNode<?> params;

    JacksonJsonRpcRequest(ObjectMapper objectMapper, ObjectNode objectNode) {
        JsonNode node;
        this.objectMapper = objectMapper;
        this.objectNode = objectNode;
        this.id = objectNode.has("id") ? ((node = objectNode.get("id")).isNull() ? null : node.textValue()) : null;
        this.method = objectNode.get("method").textValue();
        this.params = (ContainerNode)objectNode.get("params");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public int getParamCount() {
        if (this.params == null) {
            return 0;
        }
        return this.params.size();
    }

    @Override
    public Object getParams() {
        return this.params;
    }

    @Override
    public Object[] getParams(Type[] types) {
        if (this.params == null) {
            return new Object[0];
        }
        try {
            Object[] args = new Object[types.length];
            for (int i = 0; i < args.length; ++i) {
                JsonNode param = this.params.get(i);
                args[i] = param.isNull() ? null : this.objectMapper.convertValue((Object)param, this.objectMapper.constructType(types[i]));
            }
            return args;
        }
        catch (Exception e) {
            LOG.debug("params error!", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getParamsAsJson() throws JsonException {
        try {
            return this.objectMapper.writeValueAsString(this.params);
        }
        catch (JsonProcessingException e) {
            throw new JsonException(e);
        }
    }

    @Override
    public String toJson() throws JsonException {
        try {
            return this.objectMapper.writeValueAsString((Object)this.objectNode);
        }
        catch (JsonProcessingException e) {
            throw new JsonException(e);
        }
    }

    @Override
    public boolean isRequest() {
        return true;
    }

    @Override
    public boolean isResponse() {
        return false;
    }
}

