/*
 * Decompiled with CFR 0.152.
 */
package net.as_development.asdk.sql.server.impl;

import java.io.File;
import java.sql.DriverManager;
import java.sql.SQLException;
import net.as_development.asdk.api.sql.ISqlServer;
import org.apache.commons.io.FileUtils;
import org.apache.derby.jdbc.EmbeddedDriver;

public class EmbeddedDerbyServer
implements ISqlServer {
    private static final String DERBY_JDBC_PROTOCOL = "jdbc:derby:";
    private static final String DERBY_LOGFILE_PROPERTY = "derby.stream.error.file";
    private static final String SYSPROP_TEMPDIR = "java.io.tmpdir";
    private static final String DIRNAME_LOCAL_CACHE_DATA = "derby_embedded_sql_server_cache";
    private static final String DIRNAME_LOCAL_DB_DATA = "data";
    private static final String LOGFILE_NAME = "db.log";
    private static final String DB_ARG_CREATE_DB = ";create=true";
    private static final String DB_ARG_SHUTDOWN_DB = ";shutdown=true";
    private static final String DEFAULT_USER = "app";
    private static final String DEFAULT_PASSWORD = "app";
    private static final String DEFAULT_DB = "db";
    private File m_aWorkDir = null;
    private File m_aDbDataDir = null;
    private File m_aLogFile = null;
    private String m_sConnectionUrl = null;
    private String m_sDBName = "db";
    private String m_sUser = "app";
    private String m_sPassword = "app";
    private boolean m_bRemoveDataAfterShutdown = true;
    private boolean m_bRunning = false;

    public synchronized void setWorkDir(String sDir) throws Exception {
        if (this.m_bRunning) {
            throw new Exception("DB Server already started. Cant set new workdir then ...");
        }
        File aDir = new File(sDir);
        if (!aDir.exists()) {
            aDir.mkdirs();
        }
        if (!aDir.isDirectory()) {
            throw new IllegalArgumentException("Could not find nor create working directory '" + aDir.getAbsolutePath() + "'.");
        }
        this.m_aWorkDir = aDir;
    }

    public synchronized void enablePersistentData(boolean bPersistent) throws Exception {
        this.m_bRemoveDataAfterShutdown = !bPersistent;
    }

    @Override
    public synchronized String getDriverClass() throws Exception {
        return EmbeddedDriver.class.getName();
    }

    @Override
    public synchronized String getConnectionUrl() throws Exception {
        return this.mem_ConnectionUrl();
    }

    @Override
    public synchronized void setInterface(String sInterface) throws Exception {
    }

    @Override
    public synchronized void setHost(String sHost) throws Exception {
    }

    @Override
    public synchronized void setPort(int nPort) throws Exception {
    }

    @Override
    public synchronized void setDBName(String sDBName) throws Exception {
        if (this.m_bRunning) {
            throw new Exception("DB Server already started. Cant set new DB name then ...");
        }
        this.m_sDBName = sDBName;
    }

    @Override
    public synchronized void setUser(String sUser) throws Exception {
        if (this.m_bRunning) {
            throw new Exception("DB Server already started. Cant set new admin user then ...");
        }
        this.m_sUser = sUser;
    }

    @Override
    public synchronized String getUser() throws Exception {
        return this.m_sUser;
    }

    @Override
    public synchronized void setPassword(String sPassword) throws Exception {
        if (this.m_bRunning) {
            throw new Exception("DB Server already started. Cant set new admin password then ...");
        }
        this.m_sPassword = sPassword;
    }

    @Override
    public synchronized String getPassword() throws Exception {
        return this.m_sPassword;
    }

    @Override
    public synchronized boolean isRunning() throws Exception {
        return this.m_bRunning;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.m_bRunning) {
            return;
        }
        File aTempDir = this.mem_WorkDir();
        if (aTempDir.exists()) {
            FileUtils.deleteQuietly((File)aTempDir);
        }
        File aLogFile = this.mem_LogFile();
        System.setProperty(DERBY_LOGFILE_PROPERTY, aLogFile.getAbsolutePath());
        String sStartUrl = this.mem_ConnectionUrl() + DB_ARG_CREATE_DB;
        DriverManager.getConnection(sStartUrl);
        this.m_bRunning = true;
    }

    @Override
    public synchronized void stop() throws Exception {
        if (!this.m_bRunning) {
            return;
        }
        String sStopUrl = this.mem_ConnectionUrl() + DB_ARG_SHUTDOWN_DB;
        try {
            DriverManager.getConnection(sStopUrl);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.m_bRemoveDataAfterShutdown) {
            FileUtils.deleteQuietly((File)this.mem_WorkDir());
        }
        System.setProperty(DERBY_LOGFILE_PROPERTY, "");
        this.m_bRunning = false;
    }

    private File mem_WorkDir() throws Exception {
        if (this.m_aWorkDir == null) {
            File aWorkDir;
            File aTempDir = new File(System.getProperty(SYSPROP_TEMPDIR));
            File aCacheDir = new File(aTempDir, DIRNAME_LOCAL_CACHE_DATA);
            this.m_aWorkDir = aWorkDir = new File(aCacheDir, this.m_sDBName);
        }
        return this.m_aWorkDir;
    }

    private File mem_DbDataDir() throws Exception {
        if (this.m_aDbDataDir == null) {
            File aDbDataDir;
            File aTempDir = this.mem_WorkDir();
            File aDbRootDir = new File(aTempDir, DIRNAME_LOCAL_DB_DATA);
            this.m_aDbDataDir = aDbDataDir = new File(aDbRootDir, this.m_sDBName);
        }
        return this.m_aDbDataDir;
    }

    private File mem_LogFile() throws Exception {
        if (this.m_aLogFile == null) {
            File aLogFile;
            File aTempDir = this.mem_WorkDir();
            this.m_aLogFile = aLogFile = new File(aTempDir, this.m_sDBName + "_" + LOGFILE_NAME);
        }
        return this.m_aLogFile;
    }

    private String mem_ConnectionUrl() throws Exception {
        if (this.m_sConnectionUrl == null) {
            File aDir = this.mem_DbDataDir();
            String sDir = aDir.getAbsolutePath();
            this.m_sConnectionUrl = DERBY_JDBC_PROTOCOL + sDir;
        }
        return this.m_sConnectionUrl;
    }
}

