/*
 * Decompiled with CFR 0.152.
 */
package net.as_development.asdk.sql.server.impl;

import java.io.File;
import net.as_development.asdk.api.sql.ISqlServer;
import org.apache.commons.io.FileUtils;
import org.hsqldb.jdbc.JDBCDriver;
import org.hsqldb.server.Server;

public class StandaloneHSQLDBServer
implements ISqlServer {
    private static final String HSQLDB_JDBC_PROTOCOL = "jdbc:hsqldb:";
    private static final String HSQL_INSECURE = "hsql";
    private static final String HSQL_SECURE = "hsqls";
    private static final String SYSPROP_TEMPDIR = "java.io.tmpdir";
    private static final String DIRNAME_LOCAL_CACHE_DATA = "hsqldb_standalone_sql_server_cache";
    private static final String DIRNAME_LOCAL_DB_DATA = "data";
    private static final String DEFAULT_USER = "SA";
    private static final String DEFAULT_PASSWORD = "";
    private static final String DEFAULT_INTERFACE = "0.0.0.0";
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 9100;
    private static final boolean DEFAULT_SECURE = false;
    private static final String DEFAULT_DB = "db";
    private Server m_aServer = null;
    private File m_aWorkDir = null;
    private File m_aDbDataDir = null;
    private String m_sConnectionUrl = null;
    private String m_sInterface = "0.0.0.0";
    private String m_sHost = "127.0.0.1";
    private int m_nPort = 9100;
    private boolean m_bSecure = false;
    private String m_sUser = "SA";
    private String m_sPassword = "";
    private String m_sDBName = "db";
    private boolean m_bRemoveDataAfterShutdown = true;
    private boolean m_bRunning = false;

    public synchronized void setWorkDir(String sDir) throws Exception {
        if (this.m_bRunning) {
            throw new Exception("DB Server already started. Cant set new workdir then ...");
        }
        File aDir = new File(sDir);
        if (!aDir.exists()) {
            aDir.mkdirs();
        }
        if (!aDir.isDirectory()) {
            throw new IllegalArgumentException("Could not find nor create working directory '" + aDir.getAbsolutePath() + "'.");
        }
        this.m_aWorkDir = aDir;
    }

    public synchronized void enablePersistentData(boolean bPersistent) throws Exception {
        this.m_bRemoveDataAfterShutdown = !bPersistent;
    }

    @Override
    public synchronized String getDriverClass() throws Exception {
        return JDBCDriver.class.getName();
    }

    @Override
    public synchronized String getConnectionUrl() throws Exception {
        return this.mem_ConnectionUrl();
    }

    @Override
    public synchronized void setInterface(String sInterface) throws Exception {
        if (this.m_bRunning) {
            throw new Exception("DB Server already started. Cant set new interface then ...");
        }
        this.m_sInterface = sInterface;
    }

    @Override
    public synchronized void setHost(String sHost) throws Exception {
        if (this.m_bRunning) {
            throw new Exception("DB Server already started. Cant set new host then ...");
        }
        this.m_sHost = sHost;
    }

    @Override
    public synchronized void setPort(int nPort) throws Exception {
        if (this.m_bRunning) {
            throw new Exception("DB Server already started. Cant set new port then ...");
        }
        this.m_nPort = nPort;
    }

    @Override
    public synchronized void setDBName(String sDBName) throws Exception {
        if (this.m_bRunning) {
            throw new Exception("DB Server already started. Cant set new DB name then ...");
        }
        this.m_sDBName = sDBName;
    }

    @Override
    public synchronized void setUser(String sUser) throws Exception {
        if (this.m_bRunning) {
            throw new Exception("DB Server already started. Cant set new admin user then ...");
        }
        this.m_sUser = sUser;
    }

    @Override
    public synchronized String getUser() throws Exception {
        return this.m_sUser;
    }

    @Override
    public synchronized void setPassword(String sPassword) throws Exception {
        if (this.m_bRunning) {
            throw new Exception("DB Server already started. Cant set new admin password then ...");
        }
        this.m_sPassword = sPassword;
    }

    @Override
    public synchronized String getPassword() throws Exception {
        return this.m_sPassword;
    }

    @Override
    public synchronized boolean isRunning() throws Exception {
        return this.m_bRunning;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.m_bRunning) {
            return;
        }
        Server aServer = new Server();
        aServer.setAddress(this.m_sInterface);
        aServer.setPort(this.m_nPort);
        aServer.setDatabaseName(0, this.m_sDBName);
        aServer.setDatabasePath(0, this.mem_DbDataDir().toURI().toString());
        aServer.start();
        this.m_aServer = aServer;
        this.m_bRunning = true;
    }

    @Override
    public synchronized void stop() throws Exception {
        if (!this.m_bRunning) {
            return;
        }
        Server aServer = this.m_aServer;
        this.m_aServer = null;
        aServer.stop();
        if (this.m_bRemoveDataAfterShutdown) {
            FileUtils.deleteQuietly((File)this.mem_WorkDir());
        }
        this.m_bRunning = false;
    }

    private File mem_WorkDir() throws Exception {
        if (this.m_aWorkDir == null) {
            File aWorkDir;
            File aTempDir = new File(System.getProperty(SYSPROP_TEMPDIR));
            File aCacheDir = new File(aTempDir, DIRNAME_LOCAL_CACHE_DATA);
            this.m_aWorkDir = aWorkDir = new File(aCacheDir, this.m_sDBName);
        }
        return this.m_aWorkDir;
    }

    private File mem_DbDataDir() throws Exception {
        if (this.m_aDbDataDir == null) {
            File aDbDataDir;
            File aTempDir = this.mem_WorkDir();
            File aDbRootDir = new File(aTempDir, DIRNAME_LOCAL_DB_DATA);
            this.m_aDbDataDir = aDbDataDir = new File(aDbRootDir, this.m_sDBName);
        }
        return this.m_aDbDataDir;
    }

    private String mem_ConnectionUrl() throws Exception {
        if (this.m_sConnectionUrl == null) {
            StringBuffer sURL = new StringBuffer(256);
            sURL.append(HSQLDB_JDBC_PROTOCOL);
            if (this.m_bSecure) {
                sURL.append(HSQL_SECURE);
            } else {
                sURL.append(HSQL_INSECURE);
            }
            sURL.append("://");
            sURL.append(this.m_sHost);
            sURL.append(":");
            sURL.append(this.m_nPort);
            sURL.append("/");
            sURL.append(this.m_sDBName);
            this.m_sConnectionUrl = sURL.toString();
        }
        return this.m_sConnectionUrl;
    }
}

