/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.graphs;

import java.util.ArrayList;
import java.util.Collection;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.FiniteAlphabetAutomaton;
import net.automatalib.automata.UniversalAutomaton;
import net.automatalib.automata.abstractimpl.AbstractAutomaton;
import net.automatalib.automata.graphs.StateAsNodeIDs;
import net.automatalib.automata.graphs.TransitionEdge;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.UniversalGraph;
import net.automatalib.graphs.concepts.NodeIDs;

public abstract class AbstractAutomatonGraph<S, I, T, SP, TP>
extends AbstractAutomaton<S, I, T>
implements FiniteAlphabetAutomaton<S, I, T>,
UniversalAutomaton<S, I, T, SP, TP>,
UniversalGraph<S, TransitionEdge<I, T>, SP, TransitionEdge.Property<I, TP>> {
    public static <S, I, T> Collection<TransitionEdge<I, T>> createOutgoingEdges(Automaton<S, I, T> automaton, Collection<? extends I> inputs, S state) {
        ArrayList<TransitionEdge<I, T>> result = new ArrayList<TransitionEdge<I, T>>();
        for (I input : inputs) {
            Collection transitions = automaton.getTransitions(state, input);
            if (transitions == null) continue;
            for (Object t : transitions) {
                result.add(new TransitionEdge(input, t));
            }
        }
        return result;
    }

    public static <S, I, T> Collection<S> getNodes(Automaton<S, I, T> $this) {
        return $this.getStates();
    }

    public static <S, I, T> NodeIDs<S> nodeIDs(Automaton<S, I, T> $this) {
        return new StateAsNodeIDs($this.stateIDs());
    }

    public static <S, I, T> Collection<TransitionEdge<I, T>> getOutgoingEdges(FiniteAlphabetAutomaton<S, I, T> $this, S node) {
        return AbstractAutomatonGraph.createOutgoingEdges($this, $this.getInputAlphabet(), node);
    }

    public static <S, I, T> S getTarget(Automaton<S, I, T> $this, TransitionEdge<I, T> edge) {
        return (S)$this.getSuccessor(edge.getTransition());
    }

    public static <S, I, T, V> MutableMapping<S, V> createStaticNodeMapping(Automaton<S, I, T> $this) {
        return $this.createStaticStateMapping();
    }

    public static <S, I, T, V> MutableMapping<S, V> createDynamicNodeMapping(Automaton<S, I, T> $this) {
        return $this.createDynamicStateMapping();
    }

    public static <S, I, T, SP, TP> SP getNodeProperties(UniversalAutomaton<S, I, T, SP, TP> $this, S node) {
        return (SP)$this.getStateProperty(node);
    }

    public static <S, I, T, SP, TP> TransitionEdge.Property<I, TP> getEdgeProperties(UniversalAutomaton<S, I, T, SP, TP> $this, TransitionEdge<I, T> edge) {
        return edge.property($this);
    }

    public Collection<S> getNodes() {
        return AbstractAutomatonGraph.getNodes(this);
    }

    public NodeIDs<S> nodeIDs() {
        return AbstractAutomatonGraph.nodeIDs(this);
    }

    public Collection<TransitionEdge<I, T>> getOutgoingEdges(S node) {
        return AbstractAutomatonGraph.getOutgoingEdges(this, node);
    }

    public S getTarget(TransitionEdge<I, T> edge) {
        return AbstractAutomatonGraph.getTarget(this, edge);
    }

    public <V> MutableMapping<S, V> createStaticNodeMapping() {
        return AbstractAutomatonGraph.createStaticNodeMapping(this);
    }

    public <V> MutableMapping<S, V> createDynamicNodeMapping() {
        return AbstractAutomatonGraph.createDynamicNodeMapping(this);
    }

    public SP getNodeProperty(S node) {
        return AbstractAutomatonGraph.getNodeProperties(this, node);
    }

    public TransitionEdge.Property<I, TP> getEdgeProperty(TransitionEdge<I, T> edge) {
        return AbstractAutomatonGraph.getEdgeProperties(this, edge);
    }
}

