/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words.impl;

import java.util.NoSuchElementException;
import java.util.Objects;
import net.automatalib.words.Word;

public class ExtensionWord<I>
extends Word<I> {
    private final Word<I> word;
    private final I letter;

    public ExtensionWord(Word<I> word, I letter) {
        this.word = word;
        this.letter = letter;
    }

    public I getSymbol(int index) {
        if (index == this.word.length()) {
            return this.letter;
        }
        return (I)this.word.getSymbol(index);
    }

    public int length() {
        return this.word.length() + 1;
    }

    protected Word<I> _subWord(int fromIndex, int toIndex) {
        int wLen = this.word.length();
        if (fromIndex < wLen) {
            if (toIndex <= wLen) {
                this.word.subWord(fromIndex, toIndex);
            }
            return new ExtensionWord<I>(this.word.subWord(fromIndex, wLen), this.letter);
        }
        if (fromIndex == wLen) {
            return Word.fromLetter(this.letter);
        }
        return Word.epsilon();
    }

    public java.util.Iterator<I> iterator() {
        return new Iterator<I>(this.word.iterator(), this.letter);
    }

    public void writeToArray(int offset, Object[] array, int tgtOffset, int length) {
        boolean writeLetter;
        int wordLen = this.word.length();
        boolean bl = writeLetter = offset + length > wordLen;
        if (offset < wordLen) {
            if (writeLetter) {
                --length;
            }
            this.word.writeToArray(offset, array, tgtOffset, length);
        }
        if (writeLetter) {
            array[tgtOffset + length] = this.letter;
        }
    }

    public Word<I> prepend(I symbol) {
        return new ExtensionWord<I>(this.word.prepend(symbol), this.letter);
    }

    public boolean isPrefixOf(Word<I> other) {
        int wordLen = this.word.length();
        if (wordLen >= other.length()) {
            return false;
        }
        if (!this.word.isPrefixOf(other)) {
            return false;
        }
        return Objects.equals(other.getSymbol(wordLen), this.letter);
    }

    private static final class Iterator<I>
    implements java.util.Iterator<I> {
        private final java.util.Iterator<I> wordIt;
        private final I letter;
        private boolean next = true;

        public Iterator(java.util.Iterator<I> wordIt, I letter) {
            this.wordIt = wordIt;
            this.letter = letter;
        }

        @Override
        public boolean hasNext() {
            return this.next;
        }

        @Override
        public I next() {
            if (this.wordIt.hasNext()) {
                return this.wordIt.next();
            }
            if (!this.next) {
                throw new NoSuchElementException();
            }
            this.next = false;
            return this.letter;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

