/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.abstractimpl;

import java.util.Collection;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.automata.abstractimpl.AbstractDeterministicAutomaton;
import net.automatalib.automata.abstractimpl.AbstractMutableAutomaton;

public abstract class AbstractMutableDeterministic<S, I, T, SP, TP>
extends AbstractDeterministicAutomaton<S, I, T>
implements MutableDeterministic<S, I, T, SP, TP> {
    public static <S, I, T, SP, TP> void addTransition(MutableDeterministic<S, I, T, SP, TP> $this, S state, I input, T transition) {
        Object currTrans = $this.getTransition(state, input);
        if (currTrans != null) {
            throw new IllegalStateException("Cannot add transition " + transition + " to deterministic automaton: transition already defined for state " + state + " and input " + input + ".");
        }
        $this.setTransition(state, input, transition);
    }

    public static <S, I, T, SP, TP> void removeTransition(MutableDeterministic<S, I, T, SP, TP> $this, S state, I input, T transition) {
        if (transition == null) {
            return;
        }
        Object currTrans = $this.getTransition(state, input);
        if (transition.equals(currTrans)) {
            $this.setTransition(state, input, null);
        }
    }

    public static <S, I, T, SP, TP> void removeAllTransitions(MutableDeterministic<S, I, T, SP, TP> $this, S state, I input) {
        $this.setTransition(state, input, null);
    }

    public static <S, I, T, SP, TP> void setTransitions(MutableDeterministic<S, I, T, SP, TP> $this, S state, I input, Collection<? extends T> transitions) {
        int num = transitions.size();
        if (num > 1) {
            throw new IllegalArgumentException("Deterministic automaton can not have multiple transitions for the same input symbol.");
        }
        Object trans = num > 0 ? transitions.iterator().next() : null;
        $this.setTransition(state, input, trans);
    }

    public static <S, I, T, SP, TP> void setTransition(MutableDeterministic<S, I, T, SP, TP> $this, S state, I input, S successor, TP property) {
        Object trans = $this.createTransition(successor, property);
        $this.setTransition(state, input, trans);
    }

    public static <S, I, T, SP, TP> void setInitial(MutableDeterministic<S, I, T, SP, TP> $this, S state, boolean initial) {
        Object currInitial = $this.getInitialState();
        if (state.equals(currInitial)) {
            if (!initial) {
                $this.setInitialState(null);
            }
        } else if (currInitial == null) {
            $this.setInitialState(state);
        } else {
            throw new IllegalStateException("Cannot set state '" + state + "' as " + "additional initial state (current initial state: '" + currInitial + "'.");
        }
    }

    public void addTransition(S state, I input, T transition) {
        AbstractMutableDeterministic.addTransition(this, state, input, transition);
    }

    public void addTransitions(S state, I input, Collection<? extends T> transitions) {
        AbstractMutableAutomaton.addTransitions(this, state, input, transitions);
    }

    public T addTransition(S state, I input, S successor, TP property) {
        return AbstractMutableAutomaton.addTransition(this, state, input, successor, property);
    }

    public void removeTransition(S state, I input, T transition) {
        AbstractMutableDeterministic.removeTransition(this, state, input, transition);
    }

    public void removeAllTransitions(S state, I input) {
        AbstractMutableDeterministic.removeAllTransitions(this, state, input);
    }

    public void setInitial(S state, boolean initial) {
        AbstractMutableDeterministic.setInitial(this, state, initial);
    }

    public void setTransitions(S state, I input, Collection<? extends T> transitions) {
        AbstractMutableDeterministic.setTransitions(this, state, input, transitions);
    }

    public void setTransition(S state, I input, S succ, TP properties) {
        AbstractMutableDeterministic.setTransition(this, state, input, succ, properties);
    }

    public S addInitialState(SP property) {
        return AbstractMutableAutomaton.addInitialState(this, property);
    }

    public S addInitialState() {
        return AbstractMutableAutomaton.addInitialState(this);
    }

    public S addState() {
        return AbstractMutableAutomaton.addState(this);
    }
}

