/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts.abstractimpl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.automatalib.commons.util.mappings.MapMapping;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.ts.DeterministicTransitionSystem;
import net.automatalib.ts.TransitionSystem;
import net.automatalib.ts.powerset.PowersetDTS;

public abstract class AbstractTS<S, I, T>
implements TransitionSystem<S, I, T> {
    public static <S, I, T> Set<S> getSuccessors(TransitionSystem<S, I, T> $this, S state, I input) {
        Collection transitions = $this.getTransitions(state, input);
        if (transitions == null) {
            return Collections.emptySet();
        }
        HashSet<Object> result = new HashSet<Object>(transitions.size());
        for (Object trans : transitions) {
            result.add($this.getSuccessor(trans));
        }
        return result;
    }

    public static <S, I, T> Set<S> getSuccessors(TransitionSystem<S, I, T> $this, S state, Iterable<I> input) {
        return $this.getSuccessors(Collections.singleton(state), input);
    }

    public static <S, I, T> Set<S> getSuccessors(TransitionSystem<S, I, T> $this, Collection<S> states, Iterable<I> input) {
        HashSet<Object> current = new HashSet<S>(states);
        HashSet<Object> succs = new HashSet();
        for (I sym : input) {
            for (Object state : current) {
                Set currSuccs = $this.getSuccessors(state, sym);
                if (currSuccs == null) continue;
                succs.addAll(currSuccs);
            }
            HashSet<S> tmp = current;
            current = succs;
            succs = tmp;
            succs.clear();
        }
        return current;
    }

    public static <S, I, T> Set<S> getStates(TransitionSystem<S, I, T> $this, Iterable<I> input) {
        return $this.getSuccessors((Collection)$this.getInitialStates(), input);
    }

    public static <S, I, T> PowersetDTS<S, I, T> powersetView(TransitionSystem<S, I, T> $this) {
        return new PowersetDTS<S, I, T>($this);
    }

    public static <S, I, T, V> MutableMapping<S, V> createStaticStateMapping(TransitionSystem<S, I, T> $this) {
        return new MapMapping(new HashMap());
    }

    public static <S, I, T, V> MutableMapping<S, V> createDynamicStateMapping(TransitionSystem<S, I, T> $this) {
        return new MapMapping(new HashMap());
    }

    public Set<S> getSuccessors(S state, I input) {
        return AbstractTS.getSuccessors(this, state, input);
    }

    public Set<S> getSuccessors(S state, Iterable<I> input) {
        return AbstractTS.getSuccessors(this, state, input);
    }

    public Set<S> getSuccessors(Collection<S> states, Iterable<I> input) {
        return AbstractTS.getSuccessors(this, states, input);
    }

    public Set<S> getStates(Iterable<I> input) {
        return AbstractTS.getStates(this, input);
    }

    public DeterministicTransitionSystem<? extends Set<S>, I, ? extends Collection<T>> powersetView() {
        return AbstractTS.powersetView(this);
    }

    public <V> MutableMapping<S, V> createStaticStateMapping() {
        return AbstractTS.createStaticStateMapping(this);
    }

    public <V> MutableMapping<S, V> createDynamicStateMapping() {
        return AbstractTS.createDynamicStateMapping(this);
    }
}

