/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization.dot;

import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import net.automatalib.AutomataLibProperty;
import net.automatalib.AutomataLibSettings;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.commons.util.process.ProcessUtil;
import net.automatalib.visualization.dot.DOTComponent;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DOT {
    private static final Logger LOGGER;
    private static final int MAX_WIDTH = 800;
    private static final int MAX_HEIGHT = 600;
    private static String dotExe;

    private DOT() {
    }

    public static void setDotExe(String dotExe) {
        DOT.dotExe = dotExe;
    }

    public static boolean checkUsable() {
        try {
            String[] dotCheck = DOT.buildRawDOTCommand("-V");
            return ProcessUtil.invokeProcess((String[])dotCheck) == 0;
        }
        catch (IOException | InterruptedException ex) {
            LOGGER.error("Error executing dot", (Throwable)ex);
            return false;
        }
    }

    public static String[] buildRawDOTCommand(String ... opts) {
        String[] dotArgs = new String[1 + opts.length];
        dotArgs[0] = dotExe;
        System.arraycopy(opts, 0, dotArgs, 1, opts.length);
        return dotArgs;
    }

    public static String[] buildDOTCommand(String format, String ... additionalOpts) {
        String[] dotArgs = new String[1 + additionalOpts.length];
        dotArgs[0] = "-T" + format;
        System.arraycopy(additionalOpts, 0, dotArgs, 1, additionalOpts.length);
        return DOT.buildRawDOTCommand(dotArgs);
    }

    public static InputStream runDOT(String dotText, String format, String ... additionalOpts) throws IOException {
        StringReader sr = new StringReader(dotText);
        return DOT.runDOT((Reader)sr, format, additionalOpts);
    }

    public static InputStream runDOT(Reader r, String format, String ... additionalOpts) throws IOException {
        String[] dotCommand = DOT.buildDOTCommand(format, additionalOpts);
        Process p = ProcessUtil.buildProcess((String[])dotCommand, (Reader)r, null, arg_0 -> ((Logger)LOGGER).warn(arg_0));
        return p.getInputStream();
    }

    public static InputStream runDOT(File dotFile, String format, String ... additionalOpts) throws IOException {
        return DOT.runDOT(IOUtil.asBufferedUTF8Reader((File)dotFile), format, additionalOpts);
    }

    public static void runDOT(String dotText, String format, File out) throws IOException {
        DOT.runDOT((Reader)new StringReader(dotText), format, out);
    }

    public static void runDOT(Reader r, String format, File out) throws IOException {
        String[] dotCommand = DOT.buildDOTCommand(format, "-o" + out.getAbsolutePath());
        try {
            ProcessUtil.invokeProcess((String[])dotCommand, (Reader)r, arg_0 -> ((Logger)LOGGER).warn(arg_0));
        }
        catch (InterruptedException ex) {
            LOGGER.error("Interrupted while waiting for 'dot' process to exit.", (Throwable)ex);
        }
    }

    public static void runDOT(File dotFile, String format, File out) throws IOException {
        DOT.runDOT(IOUtil.asBufferedUTF8Reader((File)dotFile), format, out);
    }

    public static void renderDOTExternal(String dotText, String format) {
        DOT.renderDOTExternal(new StringReader(dotText), format);
    }

    public static void renderDOTExternal(Reader r, String format) {
        try {
            File image = File.createTempFile("dot", format);
            DOT.runDOT(r, format, image);
            Desktop.getDesktop().open(image);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Error rendering DOT: " + e.getMessage(), "Error", 0);
        }
    }

    public static void renderDOTExternal(File dotFile, String format) throws IOException {
        DOT.renderDOTExternal(IOUtil.asBufferedUTF8Reader((File)dotFile), format);
    }

    public static void renderDOT(File dotFile, boolean modal) throws IOException {
        DOT.renderDOT(IOUtil.asBufferedUTF8Reader((File)dotFile), modal);
    }

    public static void renderDOT(Reader r, boolean modal) {
        DOTComponent cmp = DOT.createDOTComponent(r);
        if (cmp == null) {
            return;
        }
        final JDialog frame = new JDialog((Dialog)null, modal);
        JScrollPane scrollPane = new JScrollPane(cmp);
        frame.setContentPane(scrollPane);
        frame.setMaximumSize(new Dimension(800, 600));
        frame.pack();
        JMenu menu = new JMenu("File");
        menu.add(cmp.getSavePngAction());
        menu.add(cmp.getSaveDotAction());
        menu.addSeparator();
        menu.add(new AbstractAction("Close"){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispatchEvent(new WindowEvent(frame, 201));
            }
        });
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(menu);
        frame.setJMenuBar(menuBar);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
        frame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\u001b') {
                    frame.dispatchEvent(new WindowEvent(frame, 201));
                }
            }
        });
    }

    public static void renderDOT(String dotText, boolean modal) {
        DOT.renderDOT(new StringReader(dotText), modal);
    }

    public static @Nullable DOTComponent createDOTComponent(Reader r) {
        try {
            return new DOTComponent(r);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Could not run DOT: " + e.getMessage(), "Failed to run DOT", 0);
            return null;
        }
    }

    public static BufferedImage renderDOTImage(String dotText) throws IOException {
        return DOT.renderDOTImage(new StringReader(dotText));
    }

    public static BufferedImage renderDOTImage(Reader dotReader) throws IOException {
        try (InputStream pngIs = DOT.runDOT(dotReader, "png", new String[0]);){
            BufferedImage bufferedImage = ImageIO.read(pngIs);
            return bufferedImage;
        }
    }

    public static BufferedImage renderDOTImage(File dotFile) throws IOException {
        return DOT.renderDOTImage(IOUtil.asBufferedUTF8Reader((File)dotFile));
    }

    public static Writer createDotWriter(final boolean modal) {
        return new StringWriter(){

            @Override
            public void close() throws IOException {
                DOT.renderDOT(this.toString(), modal);
                super.close();
            }
        };
    }

    static {
        String dotExeName;
        LOGGER = LoggerFactory.getLogger(DOT.class);
        AutomataLibSettings settings = AutomataLibSettings.getInstance();
        String dotExePath = settings.getProperty(AutomataLibProperty.DOT_EXE_DIR);
        String dotExe = dotExeName = settings.getProperty(AutomataLibProperty.DOT_EXE_NAME, "dot");
        if (dotExePath != null) {
            Path dotBasePath = FileSystems.getDefault().getPath(dotExePath, new String[0]);
            Path resolvedDotPath = dotBasePath.resolve(dotExeName);
            dotExe = resolvedDotPath.toString();
        }
        DOT.dotExe = dotExe;
    }
}

