/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization.dot;

import java.awt.Desktop;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.graphs.Graph;
import net.automatalib.serialization.dot.DOTVisualizationHelper;
import net.automatalib.serialization.dot.GraphDOT;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.visualization.VisualizationProvider;
import net.automatalib.visualization.dot.DOT;

public class GraphVizBrowserVisualizationProvider
implements VisualizationProvider {
    private static final int PRIORITY = 10;

    public String getId() {
        return "graphviz-browser";
    }

    public int getPriority() {
        return 10;
    }

    public boolean checkUsable() {
        return DOT.checkUsable();
    }

    public <N, E> void visualize(Graph<N, E> graph, List<VisualizationHelper<N, ? super E>> helpers, boolean modal, Map<String, String> visOptions) {
        try (StringWriter sw = new StringWriter();){
            GraphDOT.writeRaw(graph, (DOTVisualizationHelper)GraphDOT.toDOTVisualizationHelper(helpers), (Appendable)sw);
            File imgTmp = File.createTempFile("graphviz-browser", ".png");
            DOT.runDOT(sw.getBuffer().toString(), "png", imgTmp);
            File htmlTmp = File.createTempFile("graphviz-browser", ".html");
            try (BufferedWriter w = new BufferedWriter(IOUtil.asUTF8Writer((File)htmlTmp));){
                w.write("<html><body><img src=\"");
                w.write(imgTmp.toURI().toString());
                w.write("\"></body></html>");
            }
            Desktop.getDesktop().browse(htmlTmp.toURI());
            if (modal) {
                JOptionPane.showMessageDialog(null, "Click OK to continue ...");
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "Could not render graph: " + ex.getMessage());
        }
    }
}

