/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization.dot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.automatalib.visualization.dot.DOTMisc;

public class ImageComponent
extends JComponent {
    private static final long serialVersionUID = -1L;
    private static final int DEFAULT_WIDTH = 320;
    private static final int DEFAULT_HEIGHT = 240;
    private BufferedImage img;
    private final Action savePngAction = new AbstractAction("Save PNG"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(DOTMisc.PNG_FILTER);
            int res = chooser.showSaveDialog(ImageComponent.this);
            if (res != 0) {
                return;
            }
            File f = chooser.getSelectedFile();
            try {
                ImageIO.write((RenderedImage)ImageComponent.this.img, "png", f);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(ImageComponent.this, "Couldn't save image: " + ex.getMessage(), "Couldn't save image", 0);
            }
        }
    };
    private boolean scale;

    public ImageComponent() {
        this.setPreferredSize(new Dimension(320, 240));
    }

    public ImageComponent(BufferedImage img) {
        this.img = img;
        Dimension dim = new Dimension(img.getWidth(), img.getHeight());
        this.setSize(dim);
        this.setPreferredSize(dim);
    }

    public void listActions(List<Action> actions) {
        actions.add(this.savePngAction);
    }

    public BufferedImage getImage() {
        return this.img;
    }

    public void setImage(BufferedImage img) {
        this.img = img;
        Dimension dim = img != null ? new Dimension(img.getWidth(), img.getHeight()) : new Dimension(320, 240);
        this.setSize(dim);
        this.setPreferredSize(dim);
        this.repaint();
    }

    public Action getSavePngAction() {
        return this.savePngAction;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.img != null) {
            if (!this.scale) {
                g.drawImage(this.img, 0, 0, null);
            } else {
                g.drawImage(this.img, 0, 0, this.getWidth(), this.getHeight(), null);
            }
        }
    }

    public void toggleScale() {
        this.setScale(!this.scale);
    }

    public void setScale(boolean scale) {
        this.scale = scale;
        this.repaint();
    }
}

