/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.algorithms.graph.apsp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.algorithms.graph.apsp.APSPResult;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.concepts.EdgeWeights;
import net.automatalib.graphs.concepts.NodeIDs;

@ParametersAreNonnullByDefault
public class FloydWarshallAPSP<N, E>
implements APSPResult<N, E> {
    private final int size;
    @Nonnull
    private final NodeIDs<N> ids;
    @Nonnull
    private final APSPRecord<N, E>[][] table;

    @Nonnull
    public static <N, E> APSPResult<N, E> findAPSP(Graph<N, E> graph, EdgeWeights<E> edgeWeights) {
        FloydWarshallAPSP<N, E> fw = new FloydWarshallAPSP<N, E>(graph, edgeWeights);
        fw.findAPSP();
        return fw;
    }

    public FloydWarshallAPSP(Graph<N, E> graph, EdgeWeights<E> ew) {
        this.size = graph.size();
        this.ids = graph.nodeIDs();
        this.table = new APSPRecord[this.size][this.size];
        this.initialize(graph, ew);
    }

    private void initialize(Graph<N, E> graph, EdgeWeights<E> ew) {
        for (int i = 0; i < this.size; ++i) {
            Object src = this.ids.getNode(i);
            Collection edges = graph.getOutgoingEdges(src);
            for (Object edge : edges) {
                Object tgt = graph.getTarget(edge);
                if (tgt.equals(src)) continue;
                int j = this.ids.getNodeId(tgt);
                float w = ew.getEdgeWeight(edge);
                APSPRecord<N, E> prev = this.table[i][j];
                if (prev != null && !(prev.distance > w)) continue;
                this.table[i][j] = new APSPRecord(edge, w);
            }
        }
    }

    public void findAPSP() {
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                if (j == i) continue;
                APSPRecord<N, E> currRec = this.table[i][j];
                for (int k = 0; k < this.size; ++k) {
                    if (k == i || k == j) continue;
                    APSPRecord<N, E> part1 = this.table[i][k];
                    APSPRecord<N, E> part2 = this.table[k][j];
                    if (part1 == null || part2 == null) continue;
                    float dist1 = part1.distance;
                    float dist2 = part2.distance;
                    float total = dist1 + dist2;
                    if (currRec == null) {
                        this.table[i][j] = currRec = new APSPRecord(total, k, part1.numEdges + part2.numEdges);
                        continue;
                    }
                    if (!(currRec.distance > total)) continue;
                    currRec.distance = total;
                    currRec.middle = k;
                    currRec.numEdges = part1.numEdges + part2.numEdges;
                }
            }
        }
    }

    @Override
    public float getShortestPathDistance(N src, N tgt) {
        int tgtId;
        int srcId = this.ids.getNodeId(src);
        APSPRecord<N, E> rec = this.table[srcId][tgtId = this.ids.getNodeId(tgt)];
        if (rec == null) {
            return Float.NEGATIVE_INFINITY;
        }
        return rec.distance;
    }

    @Override
    public List<E> getShortestPath(N src, N tgt) {
        int tgtId;
        int srcId = this.ids.getNodeId(src);
        APSPRecord<N, E> rec = this.table[srcId][tgtId = this.ids.getNodeId(tgt)];
        if (rec == null) {
            return null;
        }
        ArrayList result = new ArrayList(rec.numEdges);
        this.buildPath(result, srcId, tgtId, rec);
        return result;
    }

    private void buildPath(List<E> path, int srcId, int tgtId, APSPRecord<N, E> rec) {
        if (rec.middle == -1) {
            path.add(rec.edge);
            return;
        }
        int middle = rec.middle;
        this.buildPath(path, srcId, middle, this.table[srcId][middle]);
        this.buildPath(path, middle, tgtId, this.table[middle][tgtId]);
    }

    @ParametersAreNonnullByDefault
    private static final class APSPRecord<N, E> {
        @Nullable
        public final E edge;
        public float distance;
        public int middle;
        public int numEdges;

        public APSPRecord(E edge, float distance) {
            this.edge = edge;
            this.distance = distance;
            this.middle = -1;
            this.numEdges = 1;
        }

        public APSPRecord(float distance, int middle, int numEdges) {
            this.edge = null;
            this.distance = distance;
            this.middle = middle;
        }
    }
}

