/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.DeterministicAutomaton;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.automata.UniversalAutomaton;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.graphs.TransitionEdge;
import net.automatalib.automata.vpda.OneSEVPA;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.UniversalGraph;
import net.automatalib.util.automata.asgraph.AutomatonAsGraph;
import net.automatalib.util.automata.asgraph.UniversalAutomatonAsGraph;
import net.automatalib.util.automata.cover.Covers;
import net.automatalib.util.automata.equivalence.CharacterizingSets;
import net.automatalib.util.automata.equivalence.DeterministicEquivalenceTest;
import net.automatalib.util.automata.equivalence.NearLinearEquivalenceTest;
import net.automatalib.util.automata.vpda.OneSEVPAUtil;
import net.automatalib.util.minimizer.Block;
import net.automatalib.util.minimizer.BlockMap;
import net.automatalib.util.minimizer.MinimizationResult;
import net.automatalib.util.minimizer.Minimizer;
import net.automatalib.util.ts.TS;
import net.automatalib.words.VPDAlphabet;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
public class Automata
extends TS {
    public static <S, I, T> Graph<S, TransitionEdge<I, T>> asGraph(Automaton<S, I, T> automaton, Collection<? extends I> inputs) {
        return new AutomatonAsGraph(automaton, inputs);
    }

    public static <S, I, T, SP, TP, SO, TO, A extends MutableDeterministic<SO, ? super I, TO, ? super SP, ? super TP>> A minimize(UniversalDeterministicAutomaton<S, I, T, SP, TP> automaton, Collection<? extends I> inputs, A output) {
        Object state;
        Object rep;
        UniversalGraph<S, TransitionEdge<I, T>, SP, TransitionEdge.Property<I, TP>> aag = Automata.asUniversalGraph(automaton, inputs);
        MinimizationResult<Object, TransitionEdge.Property<I, TP>> mr = Minimizer.minimize(aag, Collections.singleton(automaton.getInitialState()));
        output.clear();
        Object init = automaton.getInitialState();
        Block<Object, TransitionEdge.Property<I, TP>> initBlock = mr.getBlockForState(init);
        BlockMap<Object> bm = new BlockMap<Object>(mr);
        for (Block<Object, TransitionEdge.Property<I, TP>> block : mr.getBlocks()) {
            rep = mr.getRepresentative(block);
            Object repProp = automaton.getStateProperty(rep);
            state = block == initBlock ? output.addInitialState(repProp) : output.addState(repProp);
            bm.put(block, state);
        }
        for (Block<Object, TransitionEdge.Property<I, TP>> block : mr.getBlocks()) {
            rep = mr.getRepresentative(block);
            state = bm.get(block);
            for (I input : inputs) {
                Object trans = automaton.getTransition(rep, input);
                if (trans == null) continue;
                Object prop = automaton.getTransitionProperty(trans);
                Object oldSucc = automaton.getSuccessor(trans);
                Block<Object, TransitionEdge.Property<I, TP>> succBlock = mr.getBlockForState(oldSucc);
                Object newSucc = bm.get(succBlock);
                output.addTransition(state, input, newSucc, prop);
            }
        }
        return output;
    }

    public static <S, I, T, SP, TP> UniversalGraph<S, TransitionEdge<I, T>, SP, TransitionEdge.Property<I, TP>> asUniversalGraph(UniversalAutomaton<S, I, T, SP, TP> automaton, Collection<? extends I> inputs) {
        return new UniversalAutomatonAsGraph(automaton, inputs);
    }

    public static <S, I, T, SP, TP, A extends MutableDeterministic<S, I, T, SP, TP>> A invasiveMinimize(A automaton, Collection<? extends I> inputs) {
        int i;
        Object input;
        Object state;
        ArrayList<I> inputList = inputs instanceof List ? (ArrayList<I>)inputs : new ArrayList<I>(inputs);
        int numInputs = inputs.size();
        UniversalGraph<S, TransitionEdge<? extends I, T>, SP, TransitionEdge.Property<? extends I, TP>> aag = Automata.asUniversalGraph(automaton, inputs);
        MinimizationResult<Object, TransitionEdge.Property<I, TP>> mr = Minimizer.minimize(aag, automaton.getInitialStates());
        Object init = automaton.getInitialState();
        int initId = mr.getBlockForState(init).getId();
        ResultStateRecord[] records = new ResultStateRecord[mr.getNumBlocks()];
        for (Block<S, TransitionEdge.Property<I, TP>> blk : mr.getBlocks()) {
            ResultStateRecord rec;
            int id = blk.getId();
            state = mr.getRepresentative(blk);
            Object prop = automaton.getStateProperty(state);
            records[id] = rec = new ResultStateRecord(numInputs, prop);
            for (int i2 = 0; i2 < numInputs; ++i2) {
                input = inputList.get(i2);
                Object trans = automaton.getTransition(state, input);
                if (trans == null) continue;
                Object transProp = automaton.getTransitionProperty(trans);
                Object succ = automaton.getSuccessor(trans);
                int tgtId = mr.getBlockForState(succ).getId();
                rec.transitions[i2] = new ResultTransRecord<Object>(tgtId, transProp);
            }
        }
        automaton.clear();
        Object[] states = new Object[records.length];
        for (i = 0; i < records.length; ++i) {
            ResultStateRecord rec = records[i];
            Object prop = rec.property;
            Object state2 = i == initId ? automaton.addInitialState(prop) : automaton.addState(prop);
            states[i] = state2;
        }
        for (i = 0; i < records.length; ++i) {
            ResultStateRecord rec = records[i];
            state = states[i];
            for (int j = 0; j < numInputs; ++j) {
                ResultTransRecord transRec = rec.transitions[j];
                if (transRec == null) continue;
                Object succ = states[transRec.targetId];
                input = inputList.get(j);
                automaton.addTransition(state, input, succ, transRec.property);
            }
        }
        return automaton;
    }

    public static <I> Word<I> findShortestSeparatingWord(UniversalDeterministicAutomaton<?, I, ?, ?, ?> reference, UniversalDeterministicAutomaton<?, I, ?, ?, ?> other, Collection<? extends I> inputs) {
        return DeterministicEquivalenceTest.findSeparatingWordLarge(reference, other, inputs);
    }

    public static <I> boolean testEquivalence(UniversalDeterministicAutomaton<?, I, ?, ?, ?> reference, UniversalDeterministicAutomaton<?, I, ?, ?, ?> other, Collection<? extends I> inputs) {
        return Automata.findSeparatingWord(reference, other, inputs) == null;
    }

    public static <I> boolean testEquivalence(OneSEVPA<?, I> sevpa1, OneSEVPA<?, I> sevpa2, VPDAlphabet<I> inputs) {
        return OneSEVPAUtil.testEquivalence(sevpa1, sevpa2, inputs);
    }

    public static <I> Word<I> findSeparatingWord(UniversalDeterministicAutomaton<?, I, ?, ?, ?> reference, UniversalDeterministicAutomaton<?, I, ?, ?, ?> other, Collection<? extends I> inputs) {
        return NearLinearEquivalenceTest.findSeparatingWord(reference, other, inputs);
    }

    public static <S, I> Word<I> findSeparatingWord(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, S state1, S state2, Collection<? extends I> inputs) {
        return NearLinearEquivalenceTest.findSeparatingWord(automaton, state1, state2, inputs);
    }

    public static <I> Word<I> findSeparatingWord(OneSEVPA<?, I> sevpa1, OneSEVPA<?, I> sevpa2, VPDAlphabet<I> inputs) {
        return OneSEVPAUtil.findSeparatingWord(sevpa1, sevpa2, inputs);
    }

    public static <I> List<Word<I>> characterizingSet(UniversalDeterministicAutomaton<?, I, ?, ?, ?> automaton, Collection<? extends I> inputs) {
        ArrayList<Word<I>> result = new ArrayList<Word<I>>();
        Automata.characterizingSet(automaton, inputs, result);
        return result;
    }

    public static <I> void characterizingSet(UniversalDeterministicAutomaton<?, I, ?, ?, ?> automaton, Collection<? extends I> inputs, Collection<? super Word<I>> result) {
        CharacterizingSets.findCharacterizingSet(automaton, inputs, result);
    }

    public static <I> boolean incrementalCharacterizingSet(UniversalDeterministicAutomaton<?, I, ?, ?, ?> automaton, Collection<? extends I> inputs, Collection<? extends Word<I>> oldSuffixes, Collection<? super Word<I>> newSuffixes) {
        return CharacterizingSets.findIncrementalCharacterizingSet(automaton, inputs, oldSuffixes, newSuffixes);
    }

    public static <S, I> List<Word<I>> stateCharacterizingSet(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, Collection<? extends I> inputs, S state) {
        ArrayList<Word<I>> result = new ArrayList<Word<I>>();
        Automata.stateCharacterizingSet(automaton, inputs, state, result);
        return result;
    }

    public static <S, I> void stateCharacterizingSet(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, Collection<? extends I> inputs, S state, Collection<? super Word<I>> result) {
        CharacterizingSets.findCharacterizingSet(automaton, inputs, state, result);
    }

    public static <I> List<Word<I>> stateCover(DeterministicAutomaton<?, I, ?> automaton, Collection<? extends I> inputs) {
        ArrayList<Word<I>> result = new ArrayList<Word<I>>(automaton.size());
        Covers.stateCover(automaton, inputs, result);
        return result;
    }

    public static <I> List<Word<I>> transitionCover(DeterministicAutomaton<?, I, ?> automaton, Collection<? extends I> inputs) {
        ArrayList<Word<I>> result = new ArrayList<Word<I>>(automaton.size() * inputs.size());
        Covers.transitionCover(automaton, inputs, result);
        return result;
    }

    public static <I> List<Word<I>> structuralCover(DeterministicAutomaton<?, I, ?> automaton, Collection<? extends I> inputs) {
        ArrayList<Word<I>> result = new ArrayList<Word<I>>(automaton.size() * (inputs.size() + 1));
        Covers.structuralCover(automaton, inputs, result);
        return result;
    }

    public static <S, I> Iterator<TS.TransRef<S, I, ?>> allDefinedInputsIterator(Automaton<S, I, ?> automaton, Iterable<? extends I> inputs) {
        return Automata.allDefinedInputsIterator(automaton, automaton.iterator(), inputs);
    }

    public static <S, I> Iterable<TS.TransRef<S, I, ?>> allDefinedInputs(Automaton<S, I, ?> automaton, Iterable<? extends I> inputs) {
        return Automata.allDefinedInputs(automaton, automaton, inputs);
    }

    public static <S, I> Iterable<TS.TransRef<S, I, ?>> allUndefinedInputs(Automaton<S, I, ?> automaton, Iterable<? extends I> inputs) {
        return Automata.allUndefinedTransitions(automaton, automaton, inputs);
    }

    public static <I> boolean hasUndefinedInput(Automaton<?, I, ?> automaton, Iterable<? extends I> inputs) {
        return Automata.findUndefinedInput(automaton, inputs) != null;
    }

    public static <S, I> TS.TransRef<S, I, ?> findUndefinedInput(Automaton<S, I, ?> automaton, Iterable<? extends I> inputs) {
        Iterator<TS.TransRef<S, I, ?>> it = Automata.allUndefinedInputsIterator(automaton, inputs);
        if (!it.hasNext()) {
            return null;
        }
        return it.next();
    }

    public static <S, I> Iterator<TS.TransRef<S, I, ?>> allUndefinedInputsIterator(Automaton<S, I, ?> automaton, Iterable<? extends I> inputs) {
        return Automata.allUndefinedTransitionsIterator(automaton, automaton.iterator(), inputs);
    }

    private static final class ResultStateRecord<SP, TP> {
        public final SP property;
        public final ResultTransRecord<TP>[] transitions;

        ResultStateRecord(int numInputs, SP property) {
            this.property = property;
            this.transitions = new ResultTransRecord[numInputs];
        }
    }

    private static final class ResultTransRecord<TP> {
        public final int targetId;
        public final TP property;

        ResultTransRecord(int targetId, TP property) {
            this.targetId = targetId;
            this.property = property;
        }
    }
}

