/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.ads;

import java.util.Optional;
import java.util.Set;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.graphs.ads.ADSNode;
import net.automatalib.graphs.ads.impl.ADSLeafNode;
import net.automatalib.util.automata.ads.BacktrackingSearch;
import net.automatalib.util.automata.ads.LYResult;
import net.automatalib.util.automata.ads.LeeYannakakis;
import net.automatalib.util.automata.ads.SplitTree;
import net.automatalib.util.automata.ads.StateEquivalence;
import net.automatalib.words.Alphabet;

public final class ADS {
    private ADS() {
    }

    public static <S, I, O> Optional<ADSNode<S, I, O>> compute(MealyMachine<S, I, ?, O> automaton, Alphabet<I> input, Set<S> states) {
        if (states.isEmpty()) {
            return Optional.empty();
        }
        if (states.size() == 1) {
            S singleState = states.iterator().next();
            return Optional.of(new ADSLeafNode(null, singleState));
        }
        if (states.size() == 2) {
            return StateEquivalence.compute(automaton, input, states);
        }
        if (states.size() == automaton.getStates().size()) {
            LYResult<S, I, O> result = LeeYannakakis.compute(automaton, input);
            if (result.isPresent()) {
                return Optional.of(result.get());
            }
            return Optional.empty();
        }
        return BacktrackingSearch.compute(automaton, input, states);
    }

    static <S, I, O> Optional<ADSNode<S, I, O>> compute(MealyMachine<S, I, ?, O> automaton, Alphabet<I> input, SplitTree<S, I, O> node) throws IllegalArgumentException {
        if (node.getPartition().isEmpty()) {
            throw new IllegalArgumentException("Empty partitions should be handled by the specific algorithm");
        }
        if (node.getPartition().size() == 1) {
            S state = node.getPartition().iterator().next();
            if (!node.getMapping().containsKey(state)) {
                throw new IllegalStateException();
            }
            ADSLeafNode result = new ADSLeafNode(null, node.getMapping().get(state));
            return Optional.of(result);
        }
        if (node.getPartition().size() == 2) {
            return StateEquivalence.compute(automaton, input, node);
        }
        if (node.getPartition().size() == automaton.getStates().size()) {
            throw new IllegalArgumentException("Call LeeYannakakis directly");
        }
        return BacktrackingSearch.compute(automaton, input, node);
    }
}

