/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.conformance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.commons.util.collections.AbstractThreeLevelIterator;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.commons.util.collections.ReusableIterator;
import net.automatalib.util.automata.cover.Covers;
import net.automatalib.util.automata.equivalence.CharacterizingSets;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class WMethodTestsIterator<I>
extends AbstractThreeLevelIterator<List<I>, Word<I>, Word<I>, Word<I>> {
    private final Iterable<Word<I>> prefixes;
    private final Iterable<Word<I>> suffixes;
    private final WordBuilder<I> wordBuilder = new WordBuilder();

    public WMethodTestsIterator(UniversalDeterministicAutomaton<?, I, ?, ?, ?> automaton, Collection<? extends I> inputs, int maxDepth) {
        super(CollectionsUtil.allTuples(inputs, (int)0, (int)maxDepth).iterator());
        this.prefixes = new ReusableIterator(Covers.transitionCoverIterator(automaton, inputs), new ArrayList(automaton.size() * inputs.size()));
        Iterator<Word<I>> characterizingSet = CharacterizingSets.characterizingSetIterator(automaton, inputs);
        this.suffixes = !characterizingSet.hasNext() ? Collections.singletonList(Word.epsilon()) : new ReusableIterator(characterizingSet);
    }

    protected Iterator<Word<I>> l2Iterator(List<I> l1Object) {
        return this.prefixes.iterator();
    }

    protected Iterator<Word<I>> l3Iterator(List<I> l1Object, Word<I> l2Object) {
        return this.suffixes.iterator();
    }

    protected Word<I> combine(List<I> middle, Word<I> prefix, Word<I> suffix) {
        Word word = this.wordBuilder.append(prefix).append(middle).append(suffix).toWord();
        this.wordBuilder.clear();
        return word;
    }
}

