/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.conformance;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.commons.util.collections.AbstractThreeLevelIterator;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.commons.util.collections.ConcatIterator;
import net.automatalib.commons.util.collections.ReusableIterator;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.util.automata.Automata;
import net.automatalib.util.automata.cover.Covers;
import net.automatalib.util.automata.equivalence.CharacterizingSets;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

@ParametersAreNonnullByDefault
public class WpMethodTestsIterator<I>
extends ConcatIterator<Word<I>> {
    public WpMethodTestsIterator(UniversalDeterministicAutomaton<?, I, ?, ?, ?> automaton, Collection<? extends I> alphabet, int maxDepth) {
        super((Iterator[])WpMethodTestsIterator.buildIterators(automaton, alphabet, maxDepth));
    }

    private static <I> Iterator<Word<I>>[] buildIterators(UniversalDeterministicAutomaton<?, I, ?, ?, ?> automaton, Collection<? extends I> inputs, int maxDepth) {
        HashSet stateCover = Sets.newHashSetWithExpectedSize((int)automaton.size());
        HashSet transitionCover = Sets.newHashSetWithExpectedSize((int)(automaton.size() * inputs.size()));
        Covers.cover(automaton, inputs, stateCover, transitionCover);
        Iterator<Word<I>> characterizingIter = CharacterizingSets.characterizingSetIterator(automaton, inputs);
        ReusableIterator characterizingSet = !characterizingIter.hasNext() ? Collections.singletonList(Word.epsilon()) : new ReusableIterator(characterizingIter);
        FirstPhaseIterator firstIterator = new FirstPhaseIterator(stateCover, CollectionsUtil.allTuples(inputs, (int)0, (int)maxDepth), characterizingSet);
        transitionCover.removeAll(stateCover);
        SecondPhaseIterator secondIterator = new SecondPhaseIterator(automaton, inputs, transitionCover, CollectionsUtil.allTuples(inputs, (int)0, (int)maxDepth));
        return new Iterator[]{firstIterator, secondIterator};
    }

    private static class SecondPhaseIterator<S, I>
    extends AbstractThreeLevelIterator<List<I>, Word<I>, Word<I>, Word<I>> {
        private final UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton;
        private final Collection<? extends I> inputs;
        private final MutableMapping<S, List<Word<I>>> localSuffixSets;
        private final Iterable<Word<I>> prefixes;
        private final WordBuilder<I> wordBuilder = new WordBuilder();

        SecondPhaseIterator(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, Collection<? extends I> inputs, Iterable<Word<I>> prefixes, Iterable<List<I>> middleParts) {
            super(middleParts.iterator());
            this.automaton = automaton;
            this.inputs = inputs;
            this.localSuffixSets = automaton.createStaticStateMapping();
            this.prefixes = prefixes;
        }

        protected Iterator<Word<I>> l2Iterator(List<I> l1Object) {
            return this.prefixes.iterator();
        }

        protected Iterator<Word<I>> l3Iterator(List<I> middle, Word<I> prefix) {
            Object tmp = this.automaton.getState(prefix);
            Object state = this.automaton.getSuccessor(tmp, middle);
            List<Word<I>> localSuffixes = (List<Word<I>>)this.localSuffixSets.get(state);
            if (localSuffixes == null) {
                localSuffixes = Automata.stateCharacterizingSet(this.automaton, this.inputs, state);
                if (localSuffixes.isEmpty()) {
                    localSuffixes = Collections.singletonList(Word.epsilon());
                }
                this.localSuffixSets.put(state, localSuffixes);
            }
            return localSuffixes.iterator();
        }

        protected Word<I> combine(List<I> middle, Word<I> prefix, Word<I> suffix) {
            Word word = this.wordBuilder.append(prefix).append(middle).append(suffix).toWord();
            this.wordBuilder.clear();
            return word;
        }
    }

    private static class FirstPhaseIterator<I>
    extends AbstractThreeLevelIterator<List<I>, Word<I>, Word<I>, Word<I>> {
        private final Iterable<Word<I>> prefixes;
        private final Iterable<Word<I>> suffixes;
        private final WordBuilder<I> wordBuilder = new WordBuilder();

        FirstPhaseIterator(Iterable<Word<I>> prefixes, Iterable<List<I>> middleParts, Iterable<Word<I>> suffixes) {
            super(middleParts.iterator());
            this.prefixes = prefixes;
            this.suffixes = suffixes;
        }

        protected Iterator<Word<I>> l2Iterator(List<I> l1Object) {
            return this.prefixes.iterator();
        }

        protected Iterator<Word<I>> l3Iterator(List<I> l1Object, Word<I> l2Object) {
            return this.suffixes.iterator();
        }

        protected Word<I> combine(List<I> middle, Word<I> prefix, Word<I> suffix) {
            Word word = this.wordBuilder.append(prefix).append(middle).append(suffix).toWord();
            this.wordBuilder.clear();
            return word;
        }
    }
}

