/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.copy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import net.automatalib.automata.MutableAutomaton;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.ts.TransitionPredicate;
import net.automatalib.ts.TransitionSystem;
import net.automatalib.util.automata.copy.LowLevelAutomatonCopier;

public abstract class AbstractLowLevelAutomatonCopier<S1, I1, T1, S2, I2, T2, SP2, TP2, TS1 extends TransitionSystem<S1, ? super I1, T1>>
implements LowLevelAutomatonCopier<S1, I1, T1, S2, I2, T2, SP2, TP2> {
    protected final TS1 in;
    protected final Collection<? extends I1> inputs;
    protected final MutableAutomaton<S2, I2, T2, ? super SP2, ? super TP2> out;
    protected final MutableMapping<S1, S2> stateMapping;
    protected final Function<? super I1, ? extends I2> inputsMapping;
    protected final Function<? super S1, ? extends SP2> spMapping;
    protected final Function<? super T1, ? extends TP2> tpMapping;
    protected final Predicate<? super S1> stateFilter;
    protected final TransitionPredicate<? super S1, ? super I1, ? super T1> transFilter;

    public AbstractLowLevelAutomatonCopier(TS1 in, Collection<? extends I1> inputs, MutableAutomaton<S2, I2, T2, ? super SP2, ? super TP2> out, Function<? super I1, ? extends I2> inputsMapping, Function<? super S1, ? extends SP2> spMapping, Function<? super T1, ? extends TP2> tpMapping, Predicate<? super S1> stateFilter, TransitionPredicate<? super S1, ? super I1, ? super T1> transFilter) {
        this.in = in;
        this.inputs = inputs;
        this.out = out;
        this.stateMapping = in.createStaticStateMapping();
        this.inputsMapping = inputsMapping;
        this.spMapping = spMapping;
        this.tpMapping = tpMapping;
        this.stateFilter = stateFilter;
        this.transFilter = transFilter;
    }

    protected S2 copyInitialState(S1 s1) {
        SP2 prop = this.spMapping.apply(s1);
        Object s2 = this.out.addInitialState(prop);
        this.stateMapping.put(s1, s2);
        return (S2)s2;
    }

    protected T2 copyTransition(S2 src2, I2 input2, T1 trans1, S1 succ1) {
        TP2 prop = this.tpMapping.apply(trans1);
        Object succ2 = this.stateMapping.get(succ1);
        Object trans2 = this.out.createTransition(succ2, prop);
        this.out.addTransition(src2, input2, trans2);
        return (T2)trans2;
    }

    protected void copyTransitions(S2 src2, I2 input2, Iterator<? extends T1> transitions1It) {
        ArrayList<Object> transitions2 = new ArrayList<Object>();
        while (transitions1It.hasNext()) {
            T1 trans1 = transitions1It.next();
            Object succ1 = this.in.getSuccessor(trans1);
            Object succ2 = this.stateMapping.get(succ1);
            TP2 prop = this.tpMapping.apply(trans1);
            Object trans2 = this.out.createTransition(succ2, prop);
            transitions2.add(trans2);
        }
        this.out.addTransitions(src2, input2, transitions2);
    }

    protected S2 copyTransitionChecked(S2 src2, I2 input2, T1 trans1, S1 succ1) {
        TP2 prop = this.tpMapping.apply(trans1);
        Object succ2 = this.stateMapping.get(succ1);
        Object freshSucc = null;
        if (succ2 == null) {
            freshSucc = succ2 = this.copyState(succ1);
        }
        Object trans2 = this.out.createTransition(succ2, prop);
        this.out.addTransition(src2, input2, trans2);
        return (S2)freshSucc;
    }

    protected S2 copyState(S1 s1) {
        SP2 prop = this.spMapping.apply(s1);
        Object s2 = this.out.addState(prop);
        this.stateMapping.put(s1, s2);
        return (S2)s2;
    }

    @Override
    public abstract void doCopy();

    @Override
    public Mapping<S1, S2> getStateMapping() {
        return this.stateMapping;
    }

    protected final void updateInitials() {
        for (Object init1 : this.in.getInitialStates()) {
            Object init2 = this.stateMapping.get(init1);
            if (init2 == null) continue;
            this.out.setInitial(init2, true);
        }
    }
}

