/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.cover;

import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.DeterministicAutomaton;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.util.automata.cover.IncrementalStateCoverIterator;
import net.automatalib.util.automata.cover.IncrementalTransitionCoverIterator;
import net.automatalib.util.automata.cover.Record;
import net.automatalib.util.automata.cover.TransitionCoverIterator;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
public final class Covers {
    private Covers() {
    }

    public static <I> void stateCover(DeterministicAutomaton<?, I, ?> automaton, Collection<? extends I> inputs, Collection<? super Word<I>> states) {
        Covers.cover(automaton, inputs, states::add, (? super Word<I> w) -> {});
    }

    public static <I> Iterator<Word<I>> stateCoverIterator(DeterministicAutomaton<?, I, ?> automaton, Collection<? extends I> inputs) {
        return new IncrementalStateCoverIterator(automaton, inputs, Collections.emptyList());
    }

    public static <I> void transitionCover(DeterministicAutomaton<?, I, ?> automaton, Collection<? extends I> inputs, Collection<? super Word<I>> transitions) {
        Covers.cover(automaton, inputs, (? super Word<I> w) -> {}, transitions::add);
    }

    public static <I> Iterator<Word<I>> transitionCoverIterator(DeterministicAutomaton<?, I, ?> automaton, Collection<? extends I> inputs) {
        return new TransitionCoverIterator<I>(automaton, inputs);
    }

    public static <I> void structuralCover(DeterministicAutomaton<?, I, ?> automaton, Collection<? extends I> inputs, Collection<? super Word<I>> cover) {
        Covers.cover(automaton, inputs, cover::add, cover::add);
    }

    public static <I> void cover(DeterministicAutomaton<?, I, ?> automaton, Collection<? extends I> inputs, Collection<? super Word<I>> states, Collection<? super Word<I>> transitions) {
        Covers.cover(automaton, inputs, states::add, transitions::add);
    }

    private static <S, I> void cover(DeterministicAutomaton<S, I, ?> automaton, Collection<? extends I> inputs, Consumer<? super Word<I>> states, Consumer<? super Word<I>> transitions) {
        Object curr;
        MutableMapping reach = automaton.createStaticStateMapping();
        ArrayDeque<Object> bfsQueue = new ArrayDeque<Object>();
        Object init = automaton.getInitialState();
        reach.put(init, (Object)Word.epsilon());
        bfsQueue.add(init);
        states.accept(Word.epsilon());
        while ((curr = bfsQueue.poll()) != null) {
            Word as = (Word)reach.get(curr);
            for (I in : inputs) {
                Object succ = automaton.getSuccessor(curr, in);
                if (succ == null) continue;
                Word succAs = as.append(in);
                if (reach.get(succ) == null) {
                    reach.put(succ, (Object)succAs);
                    states.accept(succAs);
                    bfsQueue.add(succ);
                }
                transitions.accept(succAs);
            }
        }
    }

    public static <S, I> boolean incrementalStateCover(DeterministicAutomaton<S, I, ?> automaton, Collection<? extends I> inputs, Collection<? extends Word<I>> oldStates, Collection<? super Word<I>> newStates) {
        Record curr;
        MutableMapping reach = automaton.createStaticStateMapping();
        boolean augmented = false;
        ArrayDeque<Record<S, I>> bfsQueue = new ArrayDeque<Record<S, I>>();
        Covers.buildReachFromStateCover(reach, bfsQueue, automaton, oldStates, Record::new);
        Object init = automaton.getInitialState();
        if (reach.get(init) == null) {
            Record rec = new Record(init, Word.epsilon());
            reach.put(init, rec);
            bfsQueue.add(rec);
            newStates.add(Word.epsilon());
            augmented = true;
        }
        while ((curr = (Record)bfsQueue.poll()) != null) {
            Object state = curr.state;
            Word as = curr.accessSequence;
            for (I in : inputs) {
                Object succ = automaton.getSuccessor(state, in);
                if (succ == null || reach.get(succ) != null) continue;
                Word succAs = as.append(in);
                Record succRec = new Record(succ, succAs);
                reach.put(succ, succRec);
                bfsQueue.add(succRec);
                newStates.add(succAs);
                augmented = true;
            }
        }
        return augmented;
    }

    public static <I> Iterator<Word<I>> incrementalStateCoverIterator(DeterministicAutomaton<?, I, ?> automaton, Collection<? extends I> inputs, Collection<? extends Word<I>> stateCover) {
        return new IncrementalStateCoverIterator(automaton, inputs, stateCover);
    }

    public static <I> boolean incrementalTransitionCover(DeterministicAutomaton<?, I, ?> automaton, Collection<? extends I> inputs, Collection<? extends Word<I>> oldTransCover, Collection<? super Word<I>> newTransCover) {
        int oldTransSize = newTransCover.size();
        Covers.incrementalCover(automaton, inputs, Collections.emptySet(), oldTransCover, (? super Word<I> w) -> {}, newTransCover::add);
        return oldTransSize < newTransCover.size();
    }

    public static <I> Iterator<Word<I>> incrementalTransitionCoverIterator(DeterministicAutomaton<?, I, ?> automaton, Collection<? extends I> inputs, Collection<? extends Word<I>> transitionCover) {
        return new IncrementalTransitionCoverIterator(automaton, inputs, transitionCover);
    }

    public static <I> boolean incrementalStructuralCover(DeterministicAutomaton<?, I, ?> automaton, Collection<? extends I> inputs, Collection<? extends Word<I>> oldCover, Collection<? super Word<I>> newCover) {
        int oldCoverSize = newCover.size();
        Covers.incrementalCover(automaton, inputs, oldCover, Collections.emptySet(), newCover::add, newCover::add);
        return oldCoverSize < newCover.size();
    }

    public static <I> boolean incrementalCover(DeterministicAutomaton<?, I, ?> automaton, Collection<? extends I> inputs, Collection<? extends Word<I>> oldStateCover, Collection<? extends Word<I>> oldTransCover, Collection<? super Word<I>> newStateCover, Collection<? super Word<I>> newTransCover) {
        int oldStateSize = newStateCover.size();
        int oldTransSize = newTransCover.size();
        Covers.incrementalCover(automaton, inputs, oldStateCover, oldTransCover, newStateCover::add, newTransCover::add);
        return oldStateSize < newStateCover.size() || oldTransSize < newTransCover.size();
    }

    private static <S, I> void incrementalCover(DeterministicAutomaton<S, I, ?> automaton, Collection<? extends I> inputs, Collection<? extends Word<I>> oldStateCover, Collection<? extends Word<I>> oldTransCover, Consumer<? super Word<I>> newStateCover, Consumer<? super Word<I>> newTransCover) {
        Record curr;
        MutableMapping reach = automaton.createStaticStateMapping();
        ArrayDeque<Record<S, I>> bfsQueue = new ArrayDeque<Record<S, I>>();
        Object init = automaton.getInitialState();
        Record initRec = new Record(init, Word.epsilon(), Sets.newHashSetWithExpectedSize((int)inputs.size()));
        bfsQueue.add(initRec);
        reach.put(init, initRec);
        boolean hasEpsilon = Covers.buildReachFromStateCover(reach, bfsQueue, automaton, oldStateCover, (s, as) -> new Record(s, as, Sets.newHashSetWithExpectedSize((int)inputs.size())));
        for (Word<I> oldStateAs : oldStateCover) {
            if (oldStateAs.isEmpty()) continue;
            Word asPrefix = oldStateAs.prefix(oldStateAs.length() - 1);
            Object pred = automaton.getState((Iterable)asPrefix);
            assert (pred != null);
            Record predRec = (Record)reach.get(pred);
            if (predRec == null) {
                throw new IllegalArgumentException("State cover was not prefix-closed: prefix of " + oldStateAs + " not in set");
            }
            Object lastSym = oldStateAs.lastSymbol();
            predRec.coveredInputs.add(lastSym);
        }
        if (!hasEpsilon) {
            newStateCover.accept(Word.epsilon());
        }
        Covers.buildReachFromTransitionCover(reach, bfsQueue, automaton, oldTransCover, (s, as) -> new Record(s, as, Sets.newHashSetWithExpectedSize((int)inputs.size())), newStateCover);
        while ((curr = (Record)bfsQueue.poll()) != null) {
            for (I input : inputs) {
                if (!curr.coveredInputs.add(input)) continue;
                Object succ = automaton.getSuccessor(curr.state, input);
                Word newAs = curr.accessSequence.append(input);
                if (succ == null) continue;
                Record succRec = (Record)reach.get(succ);
                if (succRec == null) {
                    succRec = new Record(succ, newAs, Sets.newHashSetWithExpectedSize((int)inputs.size()));
                    bfsQueue.add(succRec);
                    reach.put(succ, succRec);
                    newStateCover.accept(newAs);
                }
                newTransCover.accept(newAs);
            }
        }
    }

    static <S, I> boolean buildReachFromStateCover(MutableMapping<S, Record<S, I>> reach, Queue<Record<S, I>> bfsQueue, DeterministicAutomaton<S, I, ?> automaton, Collection<? extends Word<I>> oldStateCover, BiFunction<S, Word<I>, Record<S, I>> recordBuilder) {
        boolean hasEpsilon = false;
        for (Word<I> oldStateAs : oldStateCover) {
            Object state = automaton.getState(oldStateAs);
            if (state == null || reach.get(state) != null) {
                if (!oldStateAs.isEmpty()) continue;
                hasEpsilon = true;
                continue;
            }
            Record<S, I> rec = recordBuilder.apply(state, oldStateAs);
            bfsQueue.add(rec);
            reach.put(state, rec);
        }
        return hasEpsilon;
    }

    static <S, I> void buildReachFromTransitionCover(MutableMapping<S, Record<S, I>> reach, Queue<Record<S, I>> bfsQueue, DeterministicAutomaton<S, I, ?> automaton, Collection<? extends Word<I>> oldTransCover, BiFunction<S, Word<I>, Record<S, I>> recordBuilder, Consumer<? super Word<I>> newStateCallback) {
        for (Word<I> oldTransAs : oldTransCover) {
            Word predAs;
            Object pred;
            Record<S, I> rec;
            Object state = automaton.getState(oldTransAs);
            if (state != null && (rec = (Record<S, I>)reach.get(state)) == null) {
                rec = recordBuilder.apply(state, oldTransAs);
                bfsQueue.add(rec);
                reach.put(state, rec);
                newStateCallback.accept(oldTransAs);
            }
            if ((pred = automaton.getState((Iterable)(predAs = oldTransAs.prefix(oldTransAs.length() - 1)))) == null) {
                throw new IllegalArgumentException("Invalid transition: prefix of transition " + oldTransAs + " not covered by state cover");
            }
            Object lastSym = oldTransAs.lastSymbol();
            Record<S, I> predRec = (Record<S, I>)reach.get(pred);
            if (predRec == null) {
                predRec = recordBuilder.apply(state, oldTransAs);
                bfsQueue.add(predRec);
                reach.put(pred, predRec);
                newStateCallback.accept(oldTransAs);
            }
            predRec.coveredInputs.add(lastSym);
        }
    }
}

