/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.fsa;

import java.util.Collection;
import net.automatalib.automata.concepts.InputAlphabetHolder;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.MutableDFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.util.automata.copy.AutomatonCopyMethod;
import net.automatalib.util.automata.copy.AutomatonLowLevelCopy;
import net.automatalib.util.automata.fsa.MutableDFAs;
import net.automatalib.util.automata.minimizer.hopcroft.HopcroftMinimization;
import net.automatalib.util.ts.acceptors.AcceptanceCombiner;
import net.automatalib.util.ts.acceptors.Acceptors;
import net.automatalib.util.ts.acceptors.DetAcceptorComposition;
import net.automatalib.util.ts.copy.TSCopy;
import net.automatalib.util.ts.traversal.TSTraversalMethod;
import net.automatalib.words.Alphabet;

public final class DFAs {
    private DFAs() {
        throw new IllegalStateException("Constructor should never be invoked");
    }

    public static <I> CompactDFA<I> combine(DFA<?, I> dfa1, DFA<?, I> dfa2, Alphabet<I> inputAlphabet, AcceptanceCombiner combiner) {
        return DFAs.combine(dfa1, dfa2, inputAlphabet, new CompactDFA(inputAlphabet), combiner);
    }

    public static <I, S, A extends MutableDFA<S, I>> A combine(DFA<?, I> dfa1, DFA<?, I> dfa2, Collection<? extends I> inputs, A out, AcceptanceCombiner combiner) {
        DetAcceptorComposition acc = Acceptors.combine(dfa1, dfa2, combiner);
        TSCopy.copy(TSTraversalMethod.DEPTH_FIRST, acc, -1, inputs, out);
        return out;
    }

    public static <I> CompactDFA<I> and(DFA<?, I> dfa1, DFA<?, I> dfa2, Alphabet<I> inputAlphabet) {
        return DFAs.and(dfa1, dfa2, inputAlphabet, new CompactDFA(inputAlphabet));
    }

    public static <I, S, A extends MutableDFA<S, I>> A and(DFA<?, I> dfa1, DFA<?, I> dfa2, Collection<? extends I> inputs, A out) {
        return DFAs.combine(dfa1, dfa2, inputs, out, AcceptanceCombiner.AND);
    }

    public static <I> CompactDFA<I> or(DFA<?, I> dfa1, DFA<?, I> dfa2, Alphabet<I> inputAlphabet) {
        return DFAs.or(dfa1, dfa2, inputAlphabet, new CompactDFA(inputAlphabet));
    }

    public static <I, S, A extends MutableDFA<S, I>> A or(DFA<?, I> dfa1, DFA<?, I> dfa2, Collection<? extends I> inputs, A out) {
        return DFAs.combine(dfa1, dfa2, inputs, out, AcceptanceCombiner.OR);
    }

    public static <I> CompactDFA<I> xor(DFA<?, I> dfa1, DFA<?, I> dfa2, Alphabet<I> inputAlphabet) {
        return DFAs.xor(dfa1, dfa2, inputAlphabet, new CompactDFA(inputAlphabet));
    }

    public static <I, S, A extends MutableDFA<S, I>> A xor(DFA<?, I> dfa1, DFA<?, I> dfa2, Collection<? extends I> inputs, A out) {
        return DFAs.combine(dfa1, dfa2, inputs, out, AcceptanceCombiner.XOR);
    }

    public static <I> CompactDFA<I> equiv(DFA<?, I> dfa1, DFA<?, I> dfa2, Alphabet<I> inputAlphabet) {
        return DFAs.equiv(dfa1, dfa2, inputAlphabet, new CompactDFA(inputAlphabet));
    }

    public static <I, S, A extends MutableDFA<S, I>> A equiv(DFA<?, I> dfa1, DFA<?, I> dfa2, Collection<? extends I> inputs, A out) {
        return DFAs.combine(dfa1, dfa2, inputs, out, AcceptanceCombiner.EQUIV);
    }

    public static <I> CompactDFA<I> impl(DFA<?, I> dfa1, DFA<?, I> dfa2, Alphabet<I> inputAlphabet) {
        return DFAs.impl(dfa1, dfa2, inputAlphabet, new CompactDFA(inputAlphabet));
    }

    public static <I, S, A extends MutableDFA<S, I>> A impl(DFA<?, I> dfa1, DFA<?, I> dfa2, Collection<? extends I> inputs, A out) {
        return DFAs.combine(dfa1, dfa2, inputs, out, AcceptanceCombiner.IMPL);
    }

    public static <I> CompactDFA<I> complement(DFA<?, I> dfa, Alphabet<I> inputAlphabet) {
        return DFAs.complement(dfa, inputAlphabet, new CompactDFA(inputAlphabet));
    }

    public static <I, S, A extends MutableDFA<S, I>> A complement(DFA<?, I> dfa, Collection<? extends I> inputs, A out) {
        AutomatonLowLevelCopy.copy(AutomatonCopyMethod.STATE_BY_STATE, dfa, inputs, out, b -> b == null || b == false, t -> null);
        MutableDFAs.complete(out, inputs, false, true);
        return out;
    }

    public static <I> CompactDFA<I> complete(DFA<?, I> dfa, Alphabet<I> inputs) {
        return DFAs.complete(dfa, inputs, new CompactDFA(inputs));
    }

    public static <I, S, A extends MutableDFA<S, I>> A complete(DFA<?, I> dfa, Collection<? extends I> inputs, A out) {
        AutomatonLowLevelCopy.copy(AutomatonCopyMethod.DFS, dfa, inputs, out);
        MutableDFAs.complete(out, inputs, true);
        return out;
    }

    public static <I> CompactDFA<I> minimize(DFA<?, I> dfa, Alphabet<I> alphabet) {
        return HopcroftMinimization.minimizeDFA(dfa, alphabet);
    }

    public static <I, A extends DFA<?, I> & InputAlphabetHolder<I>> CompactDFA<I> minimize(A dfa) {
        return HopcroftMinimization.minimizeDFA(dfa);
    }
}

