/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.fsa;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.automatalib.automata.concepts.InputAlphabetHolder;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.fsa.MutableDFA;
import net.automatalib.automata.fsa.NFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.util.automata.Automata;
import net.automatalib.words.Alphabet;

public final class NFAs {
    private NFAs() {
    }

    public static <I> CompactDFA<I> determinize(NFA<?, I> nfa, Alphabet<I> inputAlphabet) {
        return NFAs.determinize(nfa, inputAlphabet, false, true);
    }

    public static <I> CompactDFA<I> determinize(NFA<?, I> nfa, Alphabet<I> inputAlphabet, boolean partial, boolean minimize) {
        CompactDFA result = new CompactDFA(inputAlphabet);
        NFAs.determinize(nfa, inputAlphabet, result, partial, minimize);
        return result;
    }

    public static <I> void determinize(NFA<?, I> nfa, Collection<? extends I> inputs, MutableDFA<?, I> out, boolean partial, boolean minimize) {
        NFAs.doDeterminize(nfa, inputs, out, partial);
        if (minimize) {
            Automata.invasiveMinimize(out, inputs);
        }
    }

    public static <I, A extends NFA<?, I> & InputAlphabetHolder<I>> CompactDFA<I> determinize(A nfa) {
        return NFAs.determinize(nfa, false, true);
    }

    public static <I, A extends NFA<?, I> & InputAlphabetHolder<I>> CompactDFA<I> determinize(A nfa, boolean partial, boolean minimize) {
        return NFAs.determinize(nfa, ((InputAlphabetHolder<I>)nfa).getInputAlphabet(), partial, minimize);
    }

    public static <I> void determinize(NFA<?, I> nfa, Collection<? extends I> inputs, MutableDFA<?, I> out) {
        NFAs.determinize(nfa, inputs, out, false, true);
    }

    private static <I, SI, SO> void doDeterminize(NFA<SI, I> nfa, Collection<? extends I> inputs, MutableDFA<SO, I> out, boolean partial) {
        HashMap<BitSet, Object> outStateMap = new HashMap<BitSet, Object>();
        StateIDs stateIds = nfa.stateIDs();
        ArrayDeque stack = new ArrayDeque();
        ArrayList initList = new ArrayList(nfa.getInitialStates());
        BitSet initBs = new BitSet();
        for (Object init : initList) {
            initBs.set(stateIds.getStateId(init));
        }
        boolean initAcc = nfa.isAccepting(initList);
        Object initOut = out.addInitialState(initAcc);
        outStateMap.put(initBs, initOut);
        stack.push(new DeterminizeRecord(initList, initOut));
        while (!stack.isEmpty()) {
            DeterminizeRecord curr = (DeterminizeRecord)stack.pop();
            List inStates = curr.inputStates;
            Object outState = curr.outputState;
            for (I sym : inputs) {
                BitSet succBs = new BitSet();
                ArrayList succList = new ArrayList();
                for (Object inState : inStates) {
                    for (Object succState : nfa.getSuccessors(inState, sym)) {
                        int succId = stateIds.getStateId(succState);
                        if (succBs.get(succId)) continue;
                        succBs.set(succId);
                        succList.add(succState);
                    }
                }
                if (partial && succList.isEmpty()) continue;
                Object outSucc = outStateMap.get(succBs);
                if (outSucc == null) {
                    outSucc = out.addState(nfa.isAccepting(succList));
                    outStateMap.put(succBs, outSucc);
                    stack.push(new DeterminizeRecord(succList, outSucc));
                }
                out.setTransition(outState, sym, outSucc);
            }
        }
    }

    private static final class DeterminizeRecord<SI, SO> {
        private final List<SI> inputStates;
        private final SO outputState;

        DeterminizeRecord(List<SI> inputStates, SO outputState) {
            this.inputStates = inputStates;
            this.outputState = outputState;
        }
    }
}

