/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.minimizer.hopcroft;

import net.automatalib.automata.AutomatonCreator;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.concepts.InputAlphabetHolder;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.automata.transout.impl.compact.CompactMealy;
import net.automatalib.util.partitionrefinement.PaigeTarjan;
import net.automatalib.util.partitionrefinement.PaigeTarjanExtractors;
import net.automatalib.util.partitionrefinement.PaigeTarjanInitializers;
import net.automatalib.words.Alphabet;

public final class HopcroftMinimization {
    private HopcroftMinimization() {
    }

    public static <I, O> CompactMealy<I, O> minimizeMealy(MealyMachine<?, I, ?, O> mealy, Alphabet<I> alphabet) {
        return HopcroftMinimization.minimizeMealy(mealy, alphabet, PruningMode.PRUNE_AFTER);
    }

    public static <I, O> CompactMealy<I, O> minimizeMealy(MealyMachine<?, I, ?, O> mealy, Alphabet<I> alphabet, PruningMode pruningMode) {
        return (CompactMealy)HopcroftMinimization.doMinimizeMealy(mealy, alphabet, new CompactMealy.Creator(), pruningMode);
    }

    public static <I, O, A extends MealyMachine<?, I, ?, O> & InputAlphabetHolder<I>> CompactMealy<I, O> minimizeMealy(A mealy) {
        return HopcroftMinimization.minimizeMealy(mealy, PruningMode.PRUNE_AFTER);
    }

    public static <I, O, A extends MealyMachine<?, I, ?, O> & InputAlphabetHolder<I>> CompactMealy<I, O> minimizeMealy(A mealy, PruningMode pruningMode) {
        return (CompactMealy)HopcroftMinimization.doMinimizeMealy(mealy, ((InputAlphabetHolder<I>)mealy).getInputAlphabet(), new CompactMealy.Creator(), pruningMode);
    }

    private static <S, I, T, O, A extends MutableDeterministic<?, I, ?, Void, O>> A doMinimizeMealy(MealyMachine<S, I, T, O> mealy, Alphabet<I> alphabet, AutomatonCreator<? extends A, I> creator, PruningMode pruning) {
        PaigeTarjan pt = new PaigeTarjan();
        UniversalDeterministicAutomaton.FullIntAbstraction abs = mealy.fullIntAbstraction(alphabet);
        PaigeTarjanInitializers.initCompleteDeterministic(pt, abs, PaigeTarjanInitializers.AutomatonInitialPartitioning.BY_TRANSITION_PROPERTIES, pruning == PruningMode.PRUNE_BEFORE);
        pt.initWorklist(false);
        pt.computeCoarsestStablePartition();
        return PaigeTarjanExtractors.toDeterministic(pt, creator, alphabet, abs, null, arg_0 -> ((UniversalDeterministicAutomaton.FullIntAbstraction)abs).getTransitionProperty(arg_0), pruning == PruningMode.PRUNE_AFTER);
    }

    public static <I> CompactDFA<I> minimizeDFA(DFA<?, I> dfa, Alphabet<I> alphabet) {
        return HopcroftMinimization.minimizeDFA(dfa, alphabet, PruningMode.PRUNE_AFTER);
    }

    public static <I> CompactDFA<I> minimizeDFA(DFA<?, I> dfa, Alphabet<I> alphabet, PruningMode pruningMode) {
        return (CompactDFA)HopcroftMinimization.doMinimizeDFA(dfa, alphabet, new CompactDFA.Creator(), pruningMode);
    }

    public static <I, A extends DFA<?, I> & InputAlphabetHolder<I>> CompactDFA<I> minimizeDFA(A dfa) {
        return HopcroftMinimization.minimizeDFA(dfa, PruningMode.PRUNE_AFTER);
    }

    public static <I, A extends DFA<?, I> & InputAlphabetHolder<I>> CompactDFA<I> minimizeDFA(A dfa, PruningMode pruningMode) {
        return (CompactDFA)HopcroftMinimization.doMinimizeDFA(dfa, ((InputAlphabetHolder<I>)dfa).getInputAlphabet(), new CompactDFA.Creator(), pruningMode);
    }

    private static <S, I, A extends MutableDeterministic<?, I, ?, Boolean, Void>> A doMinimizeDFA(DFA<S, I> dfa, Alphabet<I> alphabet, AutomatonCreator<A, I> creator, PruningMode pruning) {
        PaigeTarjan pt = new PaigeTarjan();
        UniversalDeterministicAutomaton.FullIntAbstraction absDfa = dfa.fullIntAbstraction(alphabet);
        PaigeTarjanInitializers.initCompleteDeterministic(pt, absDfa, PaigeTarjanInitializers.AutomatonInitialPartitioning.BY_STATE_PROPERTY, pruning == PruningMode.PRUNE_BEFORE);
        pt.initWorklist(false);
        pt.computeCoarsestStablePartition();
        return PaigeTarjanExtractors.toDeterministic(pt, creator, alphabet, absDfa, arg_0 -> ((UniversalDeterministicAutomaton.FullIntAbstraction)absDfa).getStateProperty(arg_0), null, pruning == PruningMode.PRUNE_AFTER);
    }

    public static enum PruningMode {
        PRUNE_BEFORE,
        PRUNE_AFTER,
        DONT_PRUNE;

    }
}

