/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.random;

import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.automata.transout.impl.compact.CompactMealy;
import net.automatalib.automata.vpda.DefaultOneSEVPA;
import net.automatalib.automata.vpda.Location;
import net.automatalib.util.automata.Automata;
import net.automatalib.util.automata.fsa.DFAs;
import net.automatalib.util.automata.random.RandomDeterministicAutomatonGenerator;
import net.automatalib.util.automata.random.RandomICAutomatonGenerator;
import net.automatalib.util.minimizer.OneSEVPAMinimizer;
import net.automatalib.words.Alphabet;
import net.automatalib.words.VPDAlphabet;

@ParametersAreNonnullByDefault
public class RandomAutomata {
    @Nonnull
    private final Random random;

    public RandomAutomata() {
        this(new Random());
    }

    public RandomAutomata(Random random) {
        this.random = random;
    }

    @Nonnull
    public static RandomAutomata getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Nonnull
    public static <I> CompactDFA<I> randomICDFA(Random rand, @Nonnegative int numStates, Alphabet<I> inputs, boolean minimize) {
        CompactDFA dfa = (CompactDFA)new RandomICAutomatonGenerator().withStateProperties(Random::nextBoolean).generateICDeterministicAutomaton(numStates, inputs, new CompactDFA.Creator(), rand);
        if (minimize) {
            dfa = DFAs.minimize(dfa);
        }
        return dfa;
    }

    public static <I> DefaultOneSEVPA<I> randomOneSEVPA(Random r, int locCount, VPDAlphabet<I> alphabet, double acceptanceProb, double initialRetTransProb, boolean minimize) {
        DefaultOneSEVPA result = new DefaultOneSEVPA(alphabet, locCount);
        result.addInitialLocation(r.nextDouble() < initialRetTransProb);
        for (int i = 0; i < locCount - 1; ++i) {
            Object intSym;
            Location srcLoc;
            if (alphabet.getNumInternals() == 0 || r.nextDouble() < initialRetTransProb) {
                Object callSym;
                Location stackLoc;
                int stackSym;
                Object retSym;
                do {
                    retSym = alphabet.getReturnSymbol(r.nextInt(alphabet.getNumReturns()));
                    srcLoc = result.getLocation(r.nextInt(result.size()));
                    callSym = alphabet.getCallSymbol(r.nextInt(alphabet.getNumCalls()));
                } while (result.getReturnSuccessor(srcLoc, retSym, stackSym = result.encodeStackSym((Object)(stackLoc = result.getLocation(r.nextInt(result.size()))), callSym)) != null);
                Location newLoc = result.addLocation(r.nextDouble() < acceptanceProb);
                result.setReturnSuccessor(srcLoc, retSym, stackSym, newLoc);
                continue;
            }
            do {
                intSym = alphabet.getInternalSymbol(r.nextInt(alphabet.getNumInternals()));
            } while (result.getInternalSuccessor(srcLoc = result.getLocation(r.nextInt(result.size())), intSym) != null);
            Location newLoc = result.addLocation(r.nextDouble() < acceptanceProb);
            result.setInternalSuccessor(srcLoc, intSym, newLoc);
        }
        for (Location loc : result.getLocations()) {
            for (Object intSym : alphabet.getInternalSymbols()) {
                if (result.getInternalSuccessor(loc, intSym) != null) continue;
                Location tgtLoc = result.getLocation(r.nextInt(result.size()));
                result.setInternalSuccessor(loc, intSym, tgtLoc);
            }
            for (Object callSym : alphabet.getCallSymbols()) {
                for (Location stackLoc : result.getLocations()) {
                    int stackSym = result.encodeStackSym((Object)stackLoc, callSym);
                    for (Object retSym : alphabet.getReturnSymbols()) {
                        if (result.getReturnSuccessor(loc, retSym, stackSym) != null) continue;
                        Location tgtLoc = result.getLocation(r.nextInt(result.size()));
                        result.setReturnSuccessor(loc, retSym, stackSym, tgtLoc);
                    }
                }
            }
        }
        if (minimize) {
            return OneSEVPAMinimizer.minimize(result, alphabet);
        }
        return result;
    }

    @Nonnull
    public <S, I, T, SP, TP, A extends MutableDeterministic<S, I, T, SP, TP>> A randomDeterministic(@Nonnegative int numStates, Collection<? extends I> inputs, @Nullable Collection<? extends SP> stateProps, @Nullable Collection<? extends TP> transProps, A out) {
        return RandomAutomata.randomDeterministic(this.random, numStates, inputs, stateProps, transProps, out);
    }

    @Nonnull
    public static <S, I, T, SP, TP, A extends MutableDeterministic<S, I, T, SP, TP>> A randomDeterministic(Random rand, @Nonnegative int numStates, Collection<? extends I> inputs, @Nullable Collection<? extends SP> stateProps, @Nullable Collection<? extends TP> transProps, A out) {
        return RandomAutomata.randomDeterministic(rand, numStates, inputs, stateProps, transProps, out, true);
    }

    @Nonnull
    public static <S, I, T, SP, TP, A extends MutableDeterministic<S, I, T, SP, TP>> A randomDeterministic(Random rand, @Nonnegative int numStates, Collection<? extends I> inputs, @Nullable Collection<? extends SP> stateProps, @Nullable Collection<? extends TP> transProps, A out, boolean minimize) {
        RandomDeterministicAutomatonGenerator gen = new RandomDeterministicAutomatonGenerator(rand, inputs, stateProps, transProps, out);
        gen.addStates(numStates);
        gen.addTransitions();
        gen.chooseInitial();
        if (minimize) {
            Automata.invasiveMinimize(out, inputs);
        }
        return out;
    }

    @Nonnull
    public <S, I, T, SP, TP, A extends MutableDeterministic<S, I, T, SP, TP>> A randomDeterministic(@Nonnegative int numStates, Collection<? extends I> inputs, @Nullable Collection<? extends SP> stateProps, @Nullable Collection<? extends TP> transProps, A out, boolean minimize) {
        return RandomAutomata.randomDeterministic(this.random, numStates, inputs, stateProps, transProps, out, minimize);
    }

    @Nonnull
    public <I> CompactDFA<I> randomDFA(@Nonnegative int numStates, Alphabet<I> inputs, boolean minimize) {
        return RandomAutomata.randomDFA(this.random, numStates, inputs, minimize);
    }

    @Nonnull
    public static <I> CompactDFA<I> randomDFA(Random rand, @Nonnegative int numStates, Alphabet<I> inputs, boolean minimize) {
        return RandomAutomata.randomDeterministic(rand, numStates, inputs, DFA.STATE_PROPERTIES, DFA.TRANSITION_PROPERTIES, new CompactDFA(inputs), minimize);
    }

    @Nonnull
    public <I> CompactDFA<I> randomDFA(@Nonnegative int numStates, Alphabet<I> inputs) {
        return RandomAutomata.randomDFA(this.random, numStates, inputs);
    }

    @Nonnull
    public static <I> CompactDFA<I> randomDFA(Random rand, @Nonnegative int numStates, Alphabet<I> inputs) {
        return RandomAutomata.randomDFA(rand, numStates, inputs, true);
    }

    @Nonnull
    public <I, O> CompactMealy<I, O> randomMealy(@Nonnegative int numStates, Alphabet<I> inputs, Collection<? extends O> outputs, boolean minimize) {
        return RandomAutomata.randomMealy(this.random, numStates, inputs, outputs, minimize);
    }

    @Nonnull
    public static <I, O> CompactMealy<I, O> randomMealy(Random rand, @Nonnegative int numStates, Alphabet<I> inputs, Collection<? extends O> outputs, boolean minimize) {
        return RandomAutomata.randomDeterministic(rand, numStates, inputs, Collections.singleton(null), outputs, new CompactMealy(inputs), minimize);
    }

    @Nonnull
    public <I, O> CompactMealy<I, O> randomMealy(@Nonnegative int numStates, Alphabet<I> inputs, Collection<? extends O> outputs) {
        return RandomAutomata.randomMealy(this.random, numStates, inputs, outputs);
    }

    @Nonnull
    public static <I, O> CompactMealy<I, O> randomMealy(Random rand, @Nonnegative int numStates, Alphabet<I> inputs, Collection<? extends O> outputs) {
        return RandomAutomata.randomMealy(rand, numStates, inputs, outputs, true);
    }

    private static final class InstanceHolder {
        @Nonnull
        public static final RandomAutomata INSTANCE = new RandomAutomata();

        private InstanceHolder() {
        }
    }
}

