/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.vpda;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.automatalib.automata.vpda.OneSEVPA;
import net.automatalib.commons.util.Pair;
import net.automatalib.commons.util.array.RichArray;
import net.automatalib.util.automata.vpda.OneSEVPAs;
import net.automatalib.words.VPDAlphabet;
import net.automatalib.words.Word;

public final class OneSEVPAUtil {
    private OneSEVPAUtil() {
    }

    public static <L, I> List<L> findReachableLocations(OneSEVPA<L, I> sevpa, VPDAlphabet<I> alphabet) {
        return OneSEVPAUtil.computeAccessSequences(sevpa, alphabet, (boolean)false, (Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$findReachableLocations$0(java.lang.Object ), (Ljava/lang/Object;)Z)()).reachableLocs;
    }

    public static <L, I> ReachResult<L, I> computeAccessSequences(OneSEVPA<L, I> sevpa, VPDAlphabet<I> alphabet, boolean computeAs, Predicate<? super L> terminatePred) {
        RichArray result = new RichArray(sevpa.size());
        Object initLoc = sevpa.getInitialLocation();
        ArrayList<Object> reachable = new ArrayList<Object>();
        reachable.add(initLoc);
        result.set(sevpa.getLocationId(initLoc), (Object)Word.epsilon());
        if (terminatePred.test(initLoc)) {
            return new ReachResult(initLoc, reachable, result);
        }
        int queuePtr = 0;
        while (queuePtr < reachable.size()) {
            Object curr = reachable.get(queuePtr++);
            Word currAs = (Word)result.get(sevpa.getLocationId(curr));
            for (Object intSym : alphabet.getInternalSymbols()) {
                Object succ = sevpa.getInternalSuccessor(curr, intSym);
                int succIdx = sevpa.getLocationId(succ);
                if (result.get(succIdx) != null) continue;
                Word succAs = computeAs ? currAs.append(intSym) : Word.epsilon();
                result.set(succIdx, (Object)succAs);
                if (terminatePred.test(succ)) {
                    return new ReachResult(succ, reachable, result);
                }
                reachable.add(succ);
            }
            for (Object callSym : alphabet.getCallSymbols()) {
                for (Object returnSym : alphabet.getReturnSymbols()) {
                    for (int i = 0; i < queuePtr; ++i) {
                        Word succAs;
                        Object src = reachable.get(i);
                        int stackSym = sevpa.encodeStackSym(src, callSym);
                        Object succ = sevpa.getReturnSuccessor(curr, returnSym, stackSym);
                        int succIdx = sevpa.getLocationId(succ);
                        if (result.get(succIdx) == null) {
                            succAs = computeAs ? ((Word)result.get(sevpa.getLocationId(src))).append(callSym).concat(new Word[]{currAs.append(returnSym)}) : Word.epsilon();
                            result.set(succIdx, (Object)succAs);
                            if (terminatePred.test(succ)) {
                                return new ReachResult(succ, reachable, result);
                            }
                            reachable.add(succ);
                        }
                        if (src == curr || result.get(succIdx = sevpa.getLocationId(succ = sevpa.getReturnSuccessor(src, returnSym, stackSym = sevpa.encodeStackSym(curr, callSym)))) != null) continue;
                        succAs = computeAs ? currAs.append(callSym).concat(new Word[]{((Word)result.get(sevpa.getLocationId(src))).append(returnSym)}) : Word.epsilon();
                        result.set(succIdx, (Object)succAs);
                        if (terminatePred.test(succ)) {
                            return new ReachResult(succ, reachable, result);
                        }
                        reachable.add(succ);
                    }
                }
            }
        }
        return new ReachResult(null, reachable, result);
    }

    public static <L, I> RichArray<Word<I>> computeAccessSequences(OneSEVPA<L, I> sevpa, VPDAlphabet<I> alphabet) {
        return OneSEVPAUtil.computeAccessSequences(sevpa, alphabet, (boolean)true, (Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$computeAccessSequences$1(java.lang.Object ), (Ljava/lang/Object;)Z)()).accessSequences;
    }

    public static <L, I> Word<I> findRejectedWord(OneSEVPA<L, I> sevpa, VPDAlphabet<I> alphabet) {
        return OneSEVPAUtil.computeAccessSequence(sevpa, alphabet, l -> !sevpa.isAcceptingLocation(l));
    }

    public static <L, I> Word<I> computeAccessSequence(OneSEVPA<L, I> sevpa, VPDAlphabet<I> alphabet, Predicate<? super L> predicate) {
        ReachResult<? super L, I> result = OneSEVPAUtil.computeAccessSequences(sevpa, alphabet, true, predicate);
        Object resultLoc = result.terminateLoc;
        if (resultLoc != null) {
            return (Word)result.accessSequences.get(sevpa.getLocationId(resultLoc));
        }
        return null;
    }

    public static <I> boolean testEquivalence(OneSEVPA<?, I> sevpa1, OneSEVPA<?, I> sevpa2, VPDAlphabet<I> alphabet) {
        return OneSEVPAUtil.findSeparatingWord(sevpa1, sevpa2, alphabet) == null;
    }

    public static <I> Word<I> findSeparatingWord(OneSEVPA<?, I> sevpa1, OneSEVPA<?, I> sevpa2, VPDAlphabet<I> alphabet) {
        OneSEVPA<Pair<?, ?>, I> prod = OneSEVPAs.xor(sevpa1, sevpa2, alphabet);
        return OneSEVPAUtil.findAcceptedWord(prod, alphabet);
    }

    public static <L, I> Word<I> findAcceptedWord(OneSEVPA<L, I> sevpa, VPDAlphabet<I> alphabet) {
        return OneSEVPAUtil.computeAccessSequence(sevpa, alphabet, arg_0 -> sevpa.isAcceptingLocation(arg_0));
    }

    private static /* synthetic */ boolean lambda$computeAccessSequences$1(Object l) {
        return false;
    }

    private static /* synthetic */ boolean lambda$findReachableLocations$0(Object l) {
        return false;
    }

    public static class ReachResult<L, I> {
        public final L terminateLoc;
        public final List<L> reachableLocs;
        public final RichArray<Word<I>> accessSequences;

        public ReachResult(L terminateLoc, List<L> reachableLocs, RichArray<Word<I>> accessSequences) {
            this.terminateLoc = terminateLoc;
            this.reachableLocs = reachableLocs;
            this.accessSequences = accessSequences;
        }
    }
}

