/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.vpda;

import java.util.ArrayList;
import java.util.List;
import net.automatalib.automata.vpda.AbstractOneSEVPA;
import net.automatalib.automata.vpda.OneSEVPA;
import net.automatalib.commons.util.Pair;
import net.automatalib.util.ts.acceptors.AcceptanceCombiner;
import net.automatalib.words.VPDAlphabet;

public class ProductOneSEVPA<L1, L2, I>
extends AbstractOneSEVPA<Pair<L1, L2>, I> {
    private final OneSEVPA<L1, I> sevpa1;
    private final OneSEVPA<L2, I> sevpa2;
    private final AcceptanceCombiner accCombiner;

    public ProductOneSEVPA(VPDAlphabet<I> alphabet, OneSEVPA<L1, I> sevpa1, OneSEVPA<L2, I> sevpa2, AcceptanceCombiner combiner) {
        super(alphabet);
        this.sevpa1 = sevpa1;
        this.sevpa2 = sevpa2;
        this.accCombiner = combiner;
    }

    public Pair<L1, L2> getInternalSuccessor(Pair<L1, L2> loc, I intSym) {
        Object succ1 = this.sevpa1.getInternalSuccessor(loc.getFirst(), intSym);
        if (succ1 == null) {
            return null;
        }
        Object succ2 = this.sevpa2.getInternalSuccessor(loc.getSecond(), intSym);
        if (succ2 == null) {
            return null;
        }
        return new Pair(succ1, succ2);
    }

    public Pair<L1, L2> getLocation(int id) {
        int l1Id = id / this.sevpa2.size();
        int l2Id = id % this.sevpa2.size();
        return new Pair(this.sevpa1.getLocation(l1Id), this.sevpa2.getLocation(l2Id));
    }

    public int getLocationId(Pair<L1, L2> loc) {
        return this.sevpa1.getLocationId(loc.getFirst()) * this.sevpa2.size() + this.sevpa2.getLocationId(loc.getSecond());
    }

    public List<Pair<L1, L2>> getLocations() {
        ArrayList<Pair<L1, L2>> locations = new ArrayList<Pair<L1, L2>>(this.sevpa1.size() * this.sevpa2.size());
        for (Object l1 : this.sevpa1.getLocations()) {
            for (Object l2 : this.sevpa2.getLocations()) {
                locations.add(new Pair(l1, l2));
            }
        }
        return locations;
    }

    public Pair<L1, L2> getReturnSuccessor(Pair<L1, L2> loc, I retSym, int stackSym) {
        int stackSym1 = stackSym / this.sevpa2.getNumStackSymbols();
        Object succ1 = this.sevpa1.getReturnSuccessor(loc.getFirst(), retSym, stackSym1);
        if (succ1 == null) {
            return null;
        }
        int stackSym2 = stackSym % this.sevpa2.getNumStackSymbols();
        Object succ2 = this.sevpa2.getReturnSuccessor(loc.getSecond(), retSym, stackSym2);
        if (succ2 == null) {
            return null;
        }
        return new Pair(succ1, succ2);
    }

    public boolean isAcceptingLocation(Pair<L1, L2> loc) {
        return this.accCombiner.combine(this.sevpa1.isAcceptingLocation(loc.getFirst()), this.sevpa2.isAcceptingLocation(loc.getSecond()));
    }

    public Pair<L1, L2> getInitialLocation() {
        return new Pair(this.sevpa1.getInitialLocation(), this.sevpa2.getInitialLocation());
    }

    public int encodeStackSym(Pair<L1, L2> srcLoc, I callSym) {
        int stackSym1 = this.sevpa1.encodeStackSym(srcLoc.getFirst(), callSym);
        int stackSym2 = this.sevpa2.encodeStackSym(srcLoc.getSecond(), callSym);
        return stackSym1 * this.sevpa2.getNumStackSymbols() + stackSym2;
    }

    public int getNumStackSymbols() {
        return this.sevpa1.getNumStackSymbols() * this.sevpa2.getNumStackSymbols();
    }

    public int size() {
        return this.sevpa1.size() * this.sevpa2.size();
    }
}

