/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs;

import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.automatalib.graphs.IndefiniteGraph;

public class Path<N, E>
extends AbstractList<E> {
    private final IndefiniteGraph<N, E> graph;
    private final N start;
    private final List<? extends E> edgeList;

    Path(IndefiniteGraph<N, E> graph, N start, List<? extends E> edgeList) {
        this.graph = graph;
        this.start = start;
        this.edgeList = edgeList;
    }

    public Iterator<N> nodeIterator() {
        return new NodeIterator();
    }

    public Iterable<N> nodes() {
        return this::nodeIterator;
    }

    public List<E> edgeList() {
        return Collections.unmodifiableList(this.edgeList);
    }

    public List<N> nodeList() {
        return new NodeList();
    }

    public N firstNode() {
        return this.start;
    }

    public E firstEdge() {
        if (this.edgeList.isEmpty()) {
            return null;
        }
        return this.edgeList.get(0);
    }

    public N endNode() {
        E edge = this.lastEdge();
        if (edge == null) {
            return this.start;
        }
        return (N)this.graph.getTarget(edge);
    }

    @Override
    public Iterator<E> iterator() {
        return this.edgeList.iterator();
    }

    public E lastEdge() {
        int idx = this.edgeList.size() - 1;
        if (idx < 0) {
            return null;
        }
        return this.edgeList.get(idx);
    }

    @Override
    public E get(int index) {
        return this.edgeList.get(index);
    }

    @Override
    public int size() {
        return this.edgeList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.edgeList.isEmpty();
    }

    private class NodeList
    extends AbstractList<N> {
        private NodeList() {
        }

        @Override
        public N get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (index == 0) {
                return Path.this.start;
            }
            Object edge = Path.this.edgeList.get(index - 1);
            return Path.this.graph.getTarget(edge);
        }

        @Override
        public int size() {
            return Path.this.edgeList.size() + 1;
        }

        @Override
        public Iterator<N> iterator() {
            return Path.this.nodeIterator();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    private final class NodeIterator
    implements Iterator<N> {
        private Iterator<? extends E> edgeIt;

        private NodeIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.edgeIt == null) {
                return true;
            }
            return this.edgeIt.hasNext();
        }

        @Override
        public N next() {
            if (this.edgeIt == null) {
                this.edgeIt = Path.this.edgeList.iterator();
                return Path.this.start;
            }
            Object edge = this.edgeIt.next();
            return Path.this.graph.getTarget(edge);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class PathData<N, E> {
        public final N start;
        public final List<? extends E> edgeList;

        public PathData(N start, List<? extends E> edgeList) {
            this.start = start;
            this.edgeList = edgeList;
        }

        public Path<N, E> toPath(IndefiniteGraph<N, E> graph) {
            return new Path<N, E>(graph, this.start, this.edgeList);
        }
    }
}

