/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs.scc;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.graphs.Graph;
import net.automatalib.util.graphs.scc.SCCCollector;
import net.automatalib.util.graphs.scc.SCCListener;
import net.automatalib.util.graphs.scc.TarjanSCCVisitor;
import net.automatalib.util.graphs.traversal.GraphTraversal;

@ParametersAreNonnullByDefault
public final class SCCs {
    private SCCs() {
    }

    @Nonnull
    public static <N, E> List<List<N>> collectSCCs(Graph<N, E> graph) {
        SCCCollector coll = new SCCCollector();
        SCCs.findSCCs(graph, coll);
        return coll.getSCCList();
    }

    public static <N, E> void findSCCs(Graph<N, E> graph, SCCListener<N> listener) {
        TarjanSCCVisitor vis = new TarjanSCCVisitor(graph, listener);
        for (Object node : graph) {
            if (vis.hasVisited(node)) continue;
            GraphTraversal.depthFirst(graph, node, vis);
        }
    }
}

