/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs.scc;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.commons.util.Holder;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.Graph;
import net.automatalib.util.graphs.scc.SCCListener;
import net.automatalib.util.graphs.scc.TarjanSCCRecord;
import net.automatalib.util.graphs.traversal.GraphTraversalAction;
import net.automatalib.util.graphs.traversal.GraphTraversalVisitor;

@ParametersAreNonnullByDefault
public class TarjanSCCVisitor<N, E>
implements GraphTraversalVisitor<N, E, TarjanSCCRecord> {
    private static final int SCC_FINISHED = -1;
    private final MutableMapping<N, TarjanSCCRecord> records;
    private final List<TarjanSCCRecord> currentSccRecordStack = new ArrayList<TarjanSCCRecord>();
    private final List<N> currentSccNodeStack = new ArrayList<N>();
    private final SCCListener<N> listener;
    private int counter;

    public TarjanSCCVisitor(Graph<N, E> graph, SCCListener<N> listener) {
        this.records = graph.createStaticNodeMapping();
        this.listener = listener;
    }

    @Override
    public GraphTraversalAction processInitial(N initialNode, Holder<TarjanSCCRecord> outData) {
        outData.value = this.createRecord();
        return GraphTraversalAction.EXPLORE;
    }

    @Override
    public boolean startExploration(N node, TarjanSCCRecord data) {
        this.records.put(node, (Object)data);
        return true;
    }

    @Override
    public void finishExploration(N node, TarjanSCCRecord data) {
        this.currentSccRecordStack.add(data);
        this.currentSccNodeStack.add(node);
        if (data.sccId == data.number) {
            int currScc = data.sccId;
            int numOfNodes = 0;
            ListIterator<TarjanSCCRecord> iter = this.currentSccRecordStack.listIterator(this.currentSccRecordStack.size());
            while (iter.hasPrevious()) {
                TarjanSCCRecord prev = iter.previous();
                if (prev.sccId != currScc) break;
                ++numOfNodes;
                prev.sccId = -1;
                iter.remove();
            }
            int nodeStackSize = this.currentSccNodeStack.size();
            List<N> sccNodes = this.currentSccNodeStack.subList(nodeStackSize - numOfNodes, nodeStackSize);
            this.listener.foundSCC(sccNodes);
            sccNodes.clear();
        }
    }

    @Override
    public GraphTraversalAction processEdge(N srcNode, TarjanSCCRecord srcData, E edge, N tgtNode, Holder<TarjanSCCRecord> dataHolder) {
        int tgtId;
        TarjanSCCRecord rec = (TarjanSCCRecord)this.records.get(tgtNode);
        if (rec == null) {
            rec = this.createRecord();
            dataHolder.value = rec;
            return GraphTraversalAction.EXPLORE;
        }
        if (rec.sccId != -1 && (tgtId = rec.sccId) < srcData.sccId) {
            srcData.sccId = tgtId;
        }
        return GraphTraversalAction.IGNORE;
    }

    @Override
    public void backtrackEdge(N srcNode, TarjanSCCRecord srcData, E edge, N tgtNode, TarjanSCCRecord tgtData) {
        int tgtId = tgtData.sccId;
        if (tgtId != -1 && tgtId < srcData.sccId) {
            srcData.sccId = tgtId;
        }
    }

    private TarjanSCCRecord createRecord() {
        return new TarjanSCCRecord(this.counter++);
    }

    public boolean hasVisited(N node) {
        return this.records.get(node) != null;
    }
}

