/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs.traversal;

import net.automatalib.commons.util.Holder;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.IndefiniteGraph;
import net.automatalib.util.graphs.traversal.DFSData;
import net.automatalib.util.graphs.traversal.DFSVisitor;
import net.automatalib.util.graphs.traversal.GraphTraversalAction;
import net.automatalib.util.graphs.traversal.GraphTraversalVisitor;

final class DFSTraversalVisitor<N, E, D>
implements GraphTraversalVisitor<N, E, DFSData<D>> {
    private final DFSVisitor<? super N, ? super E, D> visitor;
    private final MutableMapping<N, DFSData<D>> records;
    private int dfsNum;

    DFSTraversalVisitor(IndefiniteGraph<N, E> graph, DFSVisitor<? super N, ? super E, D> visitor) {
        this.visitor = visitor;
        this.records = graph.createStaticNodeMapping();
    }

    @Override
    public GraphTraversalAction processInitial(N initialNode, Holder<DFSData<D>> outData) {
        D data = this.visitor.initialize(initialNode);
        DFSData<D> rec = new DFSData<D>(data, this.dfsNum++);
        this.records.put(initialNode, rec);
        outData.value = rec;
        return GraphTraversalAction.EXPLORE;
    }

    @Override
    public boolean startExploration(N node, DFSData<D> data) {
        this.visitor.explore(node, data.data);
        return true;
    }

    @Override
    public void finishExploration(N node, DFSData<D> data) {
        this.visitor.finish(node, data.data);
        data.finished = true;
    }

    @Override
    public GraphTraversalAction processEdge(N srcNode, DFSData<D> srcData, E edge, N tgtNode, Holder<DFSData<D>> outData) {
        DFSData<D> tgtRec = (DFSData<D>)this.records.get(tgtNode);
        if (tgtRec == null) {
            D data = this.visitor.treeEdge(srcNode, srcData.data, edge, tgtNode);
            tgtRec = new DFSData<D>(data, this.dfsNum++);
            this.records.put(tgtNode, tgtRec);
            outData.value = tgtRec;
            return GraphTraversalAction.EXPLORE;
        }
        if (!tgtRec.finished) {
            this.visitor.backEdge(srcNode, srcData.data, edge, tgtNode, tgtRec.data);
        } else if (tgtRec.dfsNumber > srcData.dfsNumber) {
            this.visitor.forwardEdge(srcNode, srcData.data, edge, tgtNode, tgtRec.data);
        } else {
            this.visitor.crossEdge(srcNode, srcData.data, edge, tgtNode, tgtRec.data);
        }
        return GraphTraversalAction.IGNORE;
    }

    @Override
    public void backtrackEdge(N srcNode, DFSData<D> srcData, E edge, N tgtNode, DFSData<D> tgtData) {
        this.visitor.backtrackEdge(srcNode, srcData.data, edge, tgtNode, tgtData.data);
    }
}

