/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs.traversal;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.IndefiniteGraph;
import net.automatalib.util.graphs.traversal.SimpleDFRecord;
import net.automatalib.util.traversal.VisitedState;

final class DepthFirstIterator<N, E>
extends AbstractIterator<N> {
    private final MutableMapping<N, VisitedState> visited;
    private final Deque<SimpleDFRecord<N, E>> dfsStack = new ArrayDeque<SimpleDFRecord<N, E>>();
    private final IndefiniteGraph<N, E> graph;

    DepthFirstIterator(IndefiniteGraph<N, E> graph, Collection<? extends N> start) {
        this.graph = graph;
        this.visited = graph.createStaticNodeMapping();
        for (N startNode : start) {
            this.dfsStack.push(new SimpleDFRecord(startNode));
        }
    }

    protected N computeNext() {
        SimpleDFRecord<N, E> rec;
        while ((rec = this.dfsStack.peek()) != null) {
            if (!rec.wasStarted()) {
                this.visited.put(rec.node, (Object)VisitedState.VISITED);
                rec.start(this.graph);
                return rec.node;
            }
            if (rec.hasNextEdge()) {
                E edge = rec.nextEdge();
                Object tgt = this.graph.getTarget(edge);
                if (this.visited.get(tgt) == VisitedState.VISITED) continue;
                this.dfsStack.push(new SimpleDFRecord(tgt));
                continue;
            }
            this.dfsStack.pop();
        }
        return (N)this.endOfData();
    }
}

