/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.minimizer;

import java.util.Arrays;
import java.util.List;
import net.automatalib.util.minimizer.Block;
import net.automatalib.util.minimizer.BlockEdge;
import net.automatalib.util.minimizer.Edge;
import net.automatalib.util.minimizer.MinimizationResult;
import net.automatalib.util.minimizer.State;

public class BlockAutomaton<S, L> {
    private final BlockEdge<S, L>[][] edges;

    BlockAutomaton(MinimizationResult<S, L> minResult) {
        this.edges = new BlockEdge[minResult.getNumBlocks()][];
        for (Block<S, L> block : minResult.getBlocks()) {
            int id = block.getId();
            State rep = (State)((Object)block.getStates().choose());
            List outgoing = rep.getOutgoing();
            BlockEdge[] array = new BlockEdge[outgoing.size()];
            int i = 0;
            for (Edge e : outgoing) {
                array[i++] = new BlockEdge<S, L>(block, e.getTarget().getBlock(), e.getTransitionLabel().getOriginalLabel());
            }
            this.edges[id] = array;
        }
    }

    public List<BlockEdge<S, L>> getOutgoingEdges(Block<S, L> block) {
        return Arrays.asList(this.edges[block.getId()]);
    }

    public BlockEdge<S, L>[] getOutgoingEdgeArray(Block<S, L> block) {
        return this.edges[block.getId()];
    }
}

