/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.minimizer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.automatalib.graphs.UniversalIndefiniteGraph;
import net.automatalib.util.minimizer.Block;
import net.automatalib.util.minimizer.InitialPartitioning;

class HashMapInitialPartitioning<S, L>
implements InitialPartitioning<S, L> {
    private final Map<Object, Block<S, L>> initialBlockMap = new HashMap<Object, Block<S, L>>();
    private final UniversalIndefiniteGraph<S, ?, ?, L> graph;
    private int numExistingBlocks;

    HashMapInitialPartitioning(UniversalIndefiniteGraph<S, ?, ?, L> graph) {
        this.graph = graph;
    }

    @Override
    public Block<S, L> getBlock(S origState) {
        Object clazz = this.graph.getNodeProperty(origState);
        return this.initialBlockMap.computeIfAbsent(clazz, k -> new Block(this.numExistingBlocks++));
    }

    @Override
    public Collection<Block<S, L>> getInitialBlocks() {
        return this.initialBlockMap.values();
    }
}

