/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.minimizer;

import java.util.Iterator;
import net.automatalib.automata.vpda.DefaultOneSEVPA;
import net.automatalib.automata.vpda.Location;
import net.automatalib.automata.vpda.OneSEVPA;
import net.automatalib.commons.util.array.RichArray;
import net.automatalib.util.partitionrefinement.Block;
import net.automatalib.util.partitionrefinement.PaigeTarjan;
import net.automatalib.util.partitionrefinement.PaigeTarjanInitializers;
import net.automatalib.words.VPDAlphabet;

public final class OneSEVPAMinimizer {
    private OneSEVPAMinimizer() {
    }

    public static <I> DefaultOneSEVPA<I> minimize(OneSEVPA<?, I> sevpa, VPDAlphabet<I> alphabet) {
        PaigeTarjan pt = new PaigeTarjan();
        OneSEVPAMinimizer.initPaigeTarjan(pt, sevpa, alphabet);
        pt.initWorklist(false);
        pt.computeCoarsestStablePartition();
        return OneSEVPAMinimizer.fromPaigeTarjan(pt, sevpa, alphabet);
    }

    private static <L, I> void initPaigeTarjan(PaigeTarjan pt, OneSEVPA<L, I> sevpa, VPDAlphabet<I> alphabet) {
        int numStates = sevpa.size();
        int numInputs = alphabet.getNumInternals() + alphabet.getNumCalls() * alphabet.getNumReturns() * sevpa.size() * 2;
        int posDataLow = numStates;
        int predOfsDataLow = posDataLow + numStates;
        int numTransitions = numStates * numInputs;
        int predDataLow = predOfsDataLow + numTransitions + 1;
        int dataSize = predDataLow + numTransitions;
        int[] data = new int[dataSize];
        Block[] blockForState = new Block[numStates];
        Block[] initBlocks = new Block[2];
        for (int i = 0; i < numStates; ++i) {
            Iterator<Block> loc = sevpa.getLocation(i);
            int initBlockIdx = sevpa.isAcceptingLocation(loc) ? 1 : 0;
            Block block = initBlocks[initBlockIdx];
            if (block == null) {
                block = pt.createBlock();
                block.high = 0;
                initBlocks[initBlockIdx] = block;
            }
            ++block.high;
            blockForState[i] = block;
            int predCountBase = predOfsDataLow;
            for (Object intSym : alphabet.getInternalSymbols()) {
                Iterator succ = sevpa.getInternalSuccessor(loc, intSym);
                if (succ == null) {
                    throw new IllegalArgumentException();
                }
                int succId = sevpa.getLocationId((Object)succ);
                int n = predCountBase + succId;
                data[n] = data[n] + 1;
                predCountBase += numStates;
            }
            for (Object callSym : alphabet.getCallSymbols()) {
                for (Object retSym : alphabet.getReturnSymbols()) {
                    for (Object src : sevpa.getLocations()) {
                        int stackSym = sevpa.encodeStackSym(src, callSym);
                        Object succ = sevpa.getReturnSuccessor(loc, retSym, stackSym);
                        int succId = sevpa.getLocationId(succ);
                        int n = predCountBase + succId;
                        data[n] = data[n] + 1;
                        stackSym = sevpa.encodeStackSym(loc, callSym);
                        succ = sevpa.getReturnSuccessor(src, retSym, stackSym);
                        succId = sevpa.getLocationId(succ);
                        int n2 = (predCountBase += numStates) + succId;
                        data[n2] = data[n2] + 1;
                        predCountBase += numStates;
                    }
                }
            }
        }
        int curr = 0;
        for (Block b : pt.blockList()) {
            b.high = curr += b.high;
            b.low = curr;
        }
        int n = predOfsDataLow;
        data[n] = data[n] + predDataLow;
        PaigeTarjanInitializers.prefixSum(data, predOfsDataLow, predDataLow);
        for (int i = 0; i < numStates; ++i) {
            Block b = blockForState[i];
            int pos = --b.low;
            data[pos] = i;
            data[posDataLow + i] = pos;
            int predOfsBase = predOfsDataLow;
            Object loc = sevpa.getLocation(i);
            for (Object intSym : alphabet.getInternalSymbols()) {
                Object succ = sevpa.getInternalSuccessor(loc, intSym);
                if (succ == null) {
                    throw new IllegalArgumentException();
                }
                int succId = sevpa.getLocationId(succ);
                int n3 = predOfsBase + succId;
                int n4 = data[n3] - 1;
                data[n3] = n4;
                data[n4] = i;
                predOfsBase += numStates;
            }
            for (Object callSym : alphabet.getCallSymbols()) {
                for (Object retSym : alphabet.getReturnSymbols()) {
                    for (Object src : sevpa.getLocations()) {
                        int stackSym = sevpa.encodeStackSym(src, callSym);
                        Object succ = sevpa.getReturnSuccessor(loc, retSym, stackSym);
                        int succId = sevpa.getLocationId(succ);
                        int n5 = predOfsBase + succId;
                        int n6 = data[n5] - 1;
                        data[n5] = n6;
                        data[n6] = i;
                        stackSym = sevpa.encodeStackSym(loc, callSym);
                        succ = sevpa.getReturnSuccessor(src, retSym, stackSym);
                        succId = sevpa.getLocationId(succ);
                        int n7 = (predOfsBase += numStates) + succId;
                        int n8 = data[n7] - 1;
                        data[n7] = n8;
                        data[n8] = i;
                        predOfsBase += numStates;
                    }
                }
            }
        }
        pt.setBlockData(data);
        pt.setPosData(data, posDataLow);
        pt.setPredOfsData(data, predOfsDataLow);
        pt.setPredData(data);
        pt.setBlockForState(blockForState);
        pt.setSize(numStates, numInputs);
    }

    private static <L, I> DefaultOneSEVPA<I> fromPaigeTarjan(PaigeTarjan pt, OneSEVPA<L, I> original, VPDAlphabet<I> alphabet) {
        int numBlocks = pt.getNumBlocks();
        DefaultOneSEVPA result = new DefaultOneSEVPA(alphabet, numBlocks);
        RichArray resultLocs = new RichArray(numBlocks, () -> result.addLocation(false));
        for (Block curr : pt.blockList()) {
            int blockId = curr.id;
            int rep = pt.getRepresentative(curr);
            Object repLoc = original.getLocation(rep);
            Location resultLoc = (Location)resultLocs.get(blockId);
            resultLoc.setAccepting(original.isAcceptingLocation(repLoc));
            for (Object intSym : alphabet.getInternalSymbols()) {
                Object origSucc = original.getInternalSuccessor(repLoc, intSym);
                int origSuccId = original.getLocationId(origSucc);
                int resSuccId = pt.getBlockForState((int)origSuccId).id;
                Location resSucc = (Location)resultLocs.get(resSuccId);
                result.setInternalSuccessor(resultLoc, intSym, resSucc);
            }
            for (Object callSym : alphabet.getCallSymbols()) {
                for (Object retSym : alphabet.getReturnSymbols()) {
                    for (Block b : pt.blockList()) {
                        int stackRepId = pt.getRepresentative(b);
                        Object stackRep = original.getLocation(stackRepId);
                        Location resultStackRep = (Location)resultLocs.get(b.id);
                        int origStackSym = original.encodeStackSym(stackRep, callSym);
                        Object origSucc = original.getReturnSuccessor(repLoc, retSym, origStackSym);
                        int origSuccId = original.getLocationId(origSucc);
                        int resSuccId = pt.getBlockForState((int)origSuccId).id;
                        Location resSucc = (Location)resultLocs.get(resSuccId);
                        int stackSym = result.encodeStackSym((Object)resultStackRep, callSym);
                        result.setReturnSuccessor(resultLoc, retSym, stackSym, resSucc);
                    }
                }
            }
        }
        int origInit = original.getLocationId(original.getInitialLocation());
        result.setInitialLocation((Location)resultLocs.get(pt.getBlockForState((int)origInit).id));
        return result;
    }
}

