/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.partitionrefinement;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.automatalib.automata.AutomatonCreator;
import net.automatalib.automata.DeterministicAutomaton;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.commons.util.Pair;
import net.automatalib.commons.util.array.RichArray;
import net.automatalib.commons.util.functions.FunctionsUtil;
import net.automatalib.util.partitionrefinement.Block;
import net.automatalib.util.partitionrefinement.PaigeTarjan;
import net.automatalib.words.Alphabet;

public final class PaigeTarjanExtractors {
    private PaigeTarjanExtractors() {
    }

    public static <S1, S2, I, T1, T2, SP, TP, A extends MutableDeterministic<S2, I, T2, SP, TP>> A toDeterministic(PaigeTarjan pt, AutomatonCreator<A, I> creator, Alphabet<I> inputs, DeterministicAutomaton<S1, I, T1> original, StateIDs<S1> origIds, Function<? super S1, ? extends SP> spExtractor, Function<? super T1, ? extends TP> tpExtractor, boolean pruneUnreachable) {
        Function safeSpExtractor = FunctionsUtil.safeDefault(spExtractor);
        Function safeTpExtractor = FunctionsUtil.safeDefault(tpExtractor);
        if (pruneUnreachable) {
            return PaigeTarjanExtractors.toDeterministicPruned(pt, creator, inputs, original, origIds, safeSpExtractor, safeTpExtractor);
        }
        return PaigeTarjanExtractors.toDeterministicUnpruned(pt, creator, inputs, original, origIds, safeSpExtractor, safeTpExtractor);
    }

    public static <I, T, SP, TP, A extends MutableDeterministic<?, I, ?, SP, TP>> A toDeterministic(PaigeTarjan pt, AutomatonCreator<A, I> creator, Alphabet<I> inputs, DeterministicAutomaton.FullIntAbstraction<T> absOriginal, IntFunction<? extends SP> spExtractor, Function<? super T, ? extends TP> tpExtractor, boolean pruneUnreachable) {
        IntFunction safeSpExtractor = FunctionsUtil.safeDefault(spExtractor);
        Function safeTpExtractor = FunctionsUtil.safeDefault(tpExtractor);
        if (pruneUnreachable) {
            return PaigeTarjanExtractors.toDeterministicPruned(pt, creator, inputs, absOriginal, safeSpExtractor, safeTpExtractor);
        }
        return PaigeTarjanExtractors.toDeterministicUnpruned(pt, creator, inputs, absOriginal, safeSpExtractor, safeTpExtractor);
    }

    private static <S1, S2, I, T1, T2, SP, TP, A extends MutableDeterministic<S2, I, T2, SP, TP>> A toDeterministicPruned(PaigeTarjan pt, AutomatonCreator<A, I> creator, Alphabet<I> inputs, DeterministicAutomaton<S1, I, T1> original, StateIDs<S1> origIds, Function<? super S1, ? extends SP> spExtractor, Function<? super T1, ? extends TP> tpExtractor) {
        Pair curr;
        int numBlocks = pt.getNumBlocks();
        MutableDeterministic result = (MutableDeterministic)creator.createAutomaton(inputs, numBlocks);
        Object init = original.getInitialState();
        int initId = origIds.getStateId(init);
        SP initSp = spExtractor.apply(init);
        Object resInit = result.addInitialState(initSp);
        RichArray states = new RichArray(numBlocks);
        Block initBlock = pt.getBlockForState(initId);
        states.update(initBlock.id, resInit);
        ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
        queue.add(new Pair(init, resInit));
        while ((curr = (Pair)queue.poll()) != null) {
            Object state = curr.getFirst();
            Object resState = curr.getSecond();
            for (Object sym : inputs) {
                Object trans = original.getTransition(state, sym);
                if (trans == null) continue;
                TP tp = tpExtractor.apply(trans);
                Object succ = original.getSuccessor(trans);
                int succId = origIds.getStateId(succ);
                Block succBlock = pt.getBlockForState(succId);
                int succBlockId = succBlock.id;
                Object resSucc = states.get(succBlockId);
                if (resSucc == null) {
                    SP succSp = spExtractor.apply(succ);
                    resSucc = result.addState(succSp);
                    states.update(succBlockId, resSucc);
                }
                result.setTransition(resState, sym, resSucc, tp);
            }
        }
        return (A)result;
    }

    private static <I, T, SP, TP, A extends MutableDeterministic<?, I, ?, SP, TP>> A toDeterministicPruned(PaigeTarjan pt, AutomatonCreator<A, I> creator, Alphabet<I> inputs, DeterministicAutomaton.FullIntAbstraction<T> absOriginal, IntFunction<? extends SP> spExtractor, Function<? super T, ? extends TP> tpExtractor) {
        int numBlocks = pt.getNumBlocks();
        int numInputs = inputs.size();
        int[] repMap = new int[numBlocks];
        int[] stateMap = new int[numBlocks];
        Arrays.fill(stateMap, -1);
        MutableDeterministic result = (MutableDeterministic)creator.createAutomaton(inputs, numBlocks);
        MutableDeterministic.FullIntAbstraction resultAbs = result.fullIntAbstraction(inputs);
        int origInit = absOriginal.getIntInitialState();
        SP initSp = spExtractor.apply(origInit);
        int resInit = resultAbs.addIntInitialState(initSp);
        Block initBlock = pt.getBlockForState(origInit);
        stateMap[initBlock.id] = resInit;
        repMap[resInit] = origInit;
        int statesPtr = 0;
        int numStates = 1;
        while (statesPtr < numStates) {
            int resState = statesPtr++;
            int rep = repMap[resState];
            for (int i = 0; i < numInputs; ++i) {
                Object trans = absOriginal.getTransition(rep, i);
                if (trans == null) continue;
                TP tp = tpExtractor.apply(trans);
                int succ = absOriginal.getIntSuccessor(trans);
                Block succBlock = pt.getBlockForState(succ);
                int succBlockId = succBlock.id;
                int resSucc = stateMap[succBlockId];
                if (resSucc < 0) {
                    SP sp = spExtractor.apply(succ);
                    stateMap[succBlockId] = resSucc = resultAbs.addIntState(sp);
                    repMap[resSucc] = succ;
                    ++numStates;
                }
                resultAbs.setTransition(resState, i, resSucc, tp);
            }
        }
        return (A)result;
    }

    private static <S1, S2, I, T1, T2, SP, TP, A extends MutableDeterministic<S2, I, T2, SP, TP>> A toDeterministicUnpruned(PaigeTarjan pt, AutomatonCreator<A, I> creator, Alphabet<I> inputs, DeterministicAutomaton<S1, I, T1> original, StateIDs<S1> origIds, Function<? super S1, ? extends SP> spExtractor, Function<? super T1, ? extends TP> tpExtractor) {
        Object rep;
        int blockId;
        int numBlocks = pt.getNumBlocks();
        MutableDeterministic result = (MutableDeterministic)creator.createAutomaton(inputs, numBlocks);
        RichArray states = new RichArray(numBlocks);
        for (Block curr : pt.blockList()) {
            blockId = curr.id;
            rep = origIds.getState(pt.getRepresentative(curr));
            SP sp = spExtractor.apply(rep);
            Object resState = result.addState(sp);
            states.update(blockId, resState);
        }
        for (Block curr : pt.blockList()) {
            blockId = curr.id;
            rep = origIds.getState(pt.getRepresentative(curr));
            Object resultState = states.get(blockId);
            for (Object sym : inputs) {
                Object resultSucc;
                TP tp;
                Object origTrans = original.getTransition(rep, sym);
                if (origTrans != null) {
                    tp = tpExtractor.apply(origTrans);
                    Object origSucc = original.getSuccessor(origTrans);
                    int origSuccId = origIds.getStateId(origSucc);
                    resultSucc = states.get(pt.getBlockForState((int)origSuccId).id);
                } else {
                    resultSucc = null;
                    tp = null;
                }
                result.setTransition(resultState, sym, resultSucc, tp);
            }
        }
        Object origInit = original.getInitialState();
        int origInitId = origIds.getStateId(origInit);
        Object resInit = states.get(pt.getBlockForState((int)origInitId).id);
        result.setInitialState(resInit);
        return (A)result;
    }

    private static <I, T, SP, TP, A extends MutableDeterministic<?, I, ?, SP, TP>> A toDeterministicUnpruned(PaigeTarjan pt, AutomatonCreator<A, I> creator, Alphabet<I> inputs, DeterministicAutomaton.FullIntAbstraction<T> absOriginal, IntFunction<? extends SP> spExtractor, Function<? super T, ? extends TP> tpExtractor) {
        int numBlocks = pt.getNumBlocks();
        int numInputs = inputs.size();
        MutableDeterministic result = (MutableDeterministic)creator.createAutomaton(inputs, numBlocks);
        MutableDeterministic.FullIntAbstraction resultAbs = result.fullIntAbstraction(inputs);
        for (int i = 0; i < numBlocks; ++i) {
            resultAbs.addIntState();
        }
        for (Block curr : pt.blockList()) {
            int blockId = curr.id;
            int rep = pt.getRepresentative(curr);
            SP sp = spExtractor.apply(rep);
            resultAbs.setStateProperty(blockId, sp);
            for (int i = 0; i < numInputs; ++i) {
                Object trans = absOriginal.getTransition(rep, i);
                if (trans == null) continue;
                int succ = absOriginal.getIntSuccessor(trans);
                int resSucc = pt.getBlockForState((int)succ).id;
                TP tp = tpExtractor.apply(trans);
                resultAbs.setTransition(blockId, i, resSucc, tp);
            }
        }
        int origInit = absOriginal.getIntInitialState();
        resultAbs.setInitialState(pt.getBlockForState((int)origInit).id);
        return (A)result;
    }
}

