/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.tries;

import java.util.List;
import java.util.NoSuchElementException;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class SuffixTrieNode<I>
extends Word<I> {
    private final I symbol;
    private final SuffixTrieNode<I> parent;

    public SuffixTrieNode() {
        this.symbol = null;
        this.parent = null;
    }

    public SuffixTrieNode(I symbol, SuffixTrieNode<I> parent) {
        this.symbol = symbol;
        this.parent = parent;
    }

    public static <I> Word<I> toExplicitWord(SuffixTrieNode<I> node) {
        WordBuilder wb = new WordBuilder(node.depth());
        SuffixTrieNode.appendSuffix(node, wb);
        return wb.toWord();
    }

    public int depth() {
        return SuffixTrieNode.depth(this);
    }

    public static <I> int depth(SuffixTrieNode<I> node) {
        int d = 0;
        SuffixTrieNode<I> iter = node;
        while (iter.parent != null) {
            ++d;
            iter = iter.parent;
        }
        return d;
    }

    public static <I> void appendSuffix(SuffixTrieNode<I> node, List<? super I> symList) {
        SuffixTrieNode<I> iter = node;
        while (iter.parent != null) {
            symList.add(iter.symbol);
            iter = iter.parent;
        }
    }

    public void appendSuffix(List<? super I> symList) {
        SuffixTrieNode.appendSuffix(this, symList);
    }

    public I getSymbol() {
        return this.symbol;
    }

    public I getSymbol(int index) {
        return SuffixTrieNode.getSymbol(this, index);
    }

    public static <I> I getSymbol(SuffixTrieNode<I> node, int index) {
        SuffixTrieNode<I> iter = node;
        for (int i = index; i > 0; --i) {
            iter = iter.parent;
        }
        return iter.symbol;
    }

    public SuffixTrieNode<I> getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public Word<I> getSuffix() {
        if (this.parent == null) {
            return Word.epsilon();
        }
        WordBuilder wb = new WordBuilder(this.depth());
        this.appendSuffix((List<? super I>)wb);
        return wb.toWord();
    }

    public int length() {
        return this.depth();
    }

    public Iterator<I> iterator() {
        return new Iterator(this);
    }

    private static final class Iterator<I>
    implements java.util.Iterator<I> {
        private SuffixTrieNode<I> current;

        Iterator(SuffixTrieNode<I> node) {
            this.current = node;
        }

        @Override
        public boolean hasNext() {
            return !this.current.isRoot();
        }

        @Override
        public I next() {
            if (this.current.isRoot()) {
                throw new NoSuchElementException();
            }
            Object sym = ((SuffixTrieNode)this.current).symbol;
            this.current = ((SuffixTrieNode)this.current).parent;
            return (I)sym;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

