/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.ts;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import net.automatalib.ts.DeterministicTransitionSystem;
import net.automatalib.ts.TransitionSystem;
import net.automatalib.ts.UniversalTransitionSystem;
import net.automatalib.util.ts.TSIterators;
import net.automatalib.util.ts.traversal.BFSOrderIterator;

public class TS {
    protected TS() {
    }

    public static <S, I> Iterable<S> bfsOrder(TransitionSystem<S, I, ?> ts, Collection<? extends I> inputs) {
        return () -> TS.bfsOrderIterator(ts, inputs);
    }

    public static <S, I> Iterator<S> bfsOrderIterator(TransitionSystem<S, I, ?> ts, Collection<? extends I> inputs) {
        return new BFSOrderIterator(ts, inputs);
    }

    public static <S, SP> Function<S, SP> stateProperties(UniversalTransitionSystem<S, ?, ?, SP, ?> uts) {
        return arg_0 -> uts.getStateProperty(arg_0);
    }

    public static <T, TP> Function<T, TP> transitionProperties(UniversalTransitionSystem<?, ?, T, ?, TP> uts) {
        return arg_0 -> uts.getTransitionProperty(arg_0);
    }

    public static <S, I> Iterable<I> definedInputs(DeterministicTransitionSystem<S, I, ?> dts, S state, Iterable<? extends I> inputs) {
        return () -> TS.definedInputsIterator(dts, state, inputs.iterator());
    }

    public static <S, I> Iterator<I> definedInputsIterator(TransitionSystem<S, I, ?> ts, S state, Iterator<? extends I> inputsIt) {
        return new TSIterators.DefinedInputsIterator<S, I>(ts, state, inputsIt);
    }

    public static <S, I> Iterable<TransRef<S, I, ?>> allDefinedInputs(TransitionSystem<S, I, ?> ts, Iterable<? extends S> states, Iterable<? extends I> inputs) {
        return () -> TS.allDefinedInputsIterator(ts, states.iterator(), inputs);
    }

    public static <S, I> Iterator<TransRef<S, I, ?>> allDefinedInputsIterator(TransitionSystem<S, I, ?> ts, Iterator<? extends S> stateIt, Iterable<? extends I> inputs) {
        return new TSIterators.AllDefinedInputsIterator<S, I>(stateIt, ts, inputs);
    }

    public static <S, I> Iterable<I> undefinedInputs(TransitionSystem<S, I, ?> ts, S state, Iterable<? extends I> inputs) {
        return () -> TS.undefinedInputsIterator(ts, state, inputs.iterator());
    }

    public static <S, I> Iterator<I> undefinedInputsIterator(TransitionSystem<S, I, ?> ts, S state, Iterator<? extends I> inputsIt) {
        return new TSIterators.UndefinedInputsIterator<S, I>(ts, state, inputsIt);
    }

    public static <S, I> Iterable<TransRef<S, I, ?>> allUndefinedTransitions(TransitionSystem<S, I, ?> ts, Iterable<? extends S> states, Iterable<? extends I> inputs) {
        return () -> TS.allUndefinedTransitionsIterator(ts, states.iterator(), inputs);
    }

    public static <S, I> Iterator<TransRef<S, I, ?>> allUndefinedTransitionsIterator(TransitionSystem<S, I, ?> ts, Iterator<? extends S> stateIt, Iterable<? extends I> inputs) {
        return new TSIterators.AllUndefinedInputsIterator<S, I>(stateIt, ts, inputs);
    }

    public static final class TransRef<S, I, T> {
        public final S state;
        public final I input;
        public final T transition;

        public TransRef(S state, I input) {
            this(state, input, null);
        }

        public TransRef(S state, I input, T transition) {
            this.state = state;
            this.input = input;
            this.transition = transition;
        }
    }
}

